## Filter Starts With

This step filters records based on whether a named string field starts with a specified prefix.
Only those records where the field exists and starts with the given string are retained.

### Structure
1 => 0..1

### Input
A string field is required in the input record

### Parameters
* `Field` - the string field to be tested. 
* `Prefix` - the prefix of the field value.

### Output
Those input records with a valid string field which start with the prefix value

#### Notes
* If the string field doesn't exist or is not a string the record will be discarded

* ETL steps trim user-entered strings, so the prefix cannot begin or end with whitespace

#### See Also
* Filter Contains
* Filter Ends With 

