## Substitute

This step filters reads a string which can include ${substitutions} and replaces those substitutions
with the values of fields in the same record.

This step can be used to concatenate fields, for example 

```
Address: "${UnitNumber} ${BlockNumber} ${Street}"
```

### Structure
1 => 1

### Input
A string field is required in the input record

### Parameters
* `Field` - the string field to which substitutions should be applied (in-place). 

### Output
The input record with `Field` modified to include substituted values.

#### Notes
* If the string field doesn't exist or is not a string the record will be unchanged.

* Substitution will turn non-string fields into strings for substitution. In the example above, 
${BlockNumber} could be an integer, for example. However, there is no control over formatting - 
you can't decide a date should be substituted as dd/MM/yyyy - you should convert the date to a string
beforehand in a separate step to do this.

#### See Also
* None

