## Trim RegEx

This step trims whitespace from the beginning and end of string fields in-place. 
Fields to be processed are identified by regular expressions and the process can be recursively applied
to nested structures.

### Structure
1 => 1

### Input
No incoming record requirements

### Parameters
* `Field RegEx` - the regular expression that identifies field names to be modified.

* `Recursive` - whether the scan should proceed into nested documents and into arrays

### Output
The input record with those string fields identified modified to remove leading and trailing whitespace

#### Notes

* If a field identified for trimming is not a string, no change is made

* If an array matches a field regex then all string items within the array are trimmed 

* If `Recursive`, field names are tested without reference to nesting, so given a nested

```
"elxPublic": { "demo": " here " } 
``` 

only the field name "demo" will only be tested - not "elxPublic.demo" as that is not the field name.
Furthermore, the name "elxPublic" does not have to match the regex.

* Note that arrays may contain nested arrays and nested documents - 
  recursion will descend into all of them using the same rules. 

#### See Also
* Trim
