## Chain Call Field

This step can call another chain for every record received, passing that
record as the parameters to the called chain.

Unlike the `Chain Call` step, this step expects the chain to be named
in the record, hence each record can invoke a different chain. Any record
that does not include the chain field is passed through unchanged, allowing
chain expansions to occur within regular record flows.

ChainCallField is commonly used to allow several chains to contribute to 
the same output sequence of records.

### Structure
1 => 0..N

### Input
Each input record may contain a field which matches the `Chain Field` 
parameter. 

### Parameters
* Chain Field - The name of the field in the incoming record that holds
the name of the chain to invoke.

### Output
For each record in, 

* if a chain name is specified and is valid, the output will be
the results of running the named chain with the input record as parameter.

* if no chain name is specified the record is passed through unchanged

* if the chain name is invalid an error is raised

#### Notes
* Use this step to dynamically structure calls to other chains and 
accumulate the results together

#### See Also
* Chain Call
