## Chain If

This step invokes another Chain, but only when a boolean field matches
the Call If parameter. The behaviour is the same as Chain Call, but 
only when the criteria described here is satisfied.

### Structure
1 => 0..N

### Input
Each input record should provide Boolean Field (parameter below). If 
the criteria is satisfied, the record is passed as parameters to the called chain, which may 
extract the fields it needs. The called chain decides whether any input
fields are returned at the end of the called chain. 

### Parameters
* Boolean Field - The field holding the boolean value to extract
* Call If - The criteria to satisfy, ie. the boolean field value must be true or must be false
* Chain Name - The chain to call if the criteria is satisfied

### Output
For each record in, 

* If the Boolean Field matches the Call If criteria, the output will be
the results of running the named chain with the input record as parameter.

* If the Boolean Field does not match the Call If criteria (either because the field
doesn't exist, is not the right type, or does not hold the right value) then the
input record is passed directly to the output.

#### Notes
* This step provides a simple conditional execution - a sub-chain can be called 
when certain criteria are satisfied. Usually the preceding steps will set up the 
boolean field ready for testing in this step, eg. a Compare field like "age > 60"
produces a boolean which can then call a special chain 


#### See Also
* Chain Call

* Chain If/Else

