## Flatten Sub-Document

This step takes a nested document and moves all the contents up to the top level. This will overwrite any fields
at the top level with the same names as those in the nested document.

### Structure
1 => 1

### Input
Any record with a nested document can be acted upon

### Parameters
* Field - The field holding the nested document for flattening

### Output
The input record with fields from the nested document moved to the top level, overwriting any prior values.

#### Notes
* This is a useful step for merging a nested document into the top level. For example when you have a Chain to Array,
followed by an Unwind, you get one or more nested objects representing the chain results. It is common to want to flatten these
into a single level for easier manipulation.

#### See Also
* Merge Sub-Documents
* Chain to Array
* Array Unwind

