## Idle Json Record

This step inserts Json records into the chain at regular time intervals until all records in the main flow have been processed.  IdleJsonRecord holds a single Json object {...} which is inserted potentially multiple times.

The step is intended to keep the chain "alive" by passing through dummy records so that there is always some activity even when the main flow is not producing records. This allows other steps, eg. `Sum Window` to update the values even when the upstream stages are not supplying records.

### Structure
1 => N

### Input
None required

### Parameters
* `Injection Interval (secs)` = How frequently to inject the idle json record 

* `JSON` - The Json object to be merged into the chain when the upstream at the desired frequency

### Output
All upstream records are passed through unchanged. Additional "idle" records are generated at a fixed interval.

#### Notes

* If multiple json records are provided (eg. an array) only the first will be used

* The injected record flow will stop only when the main incoming record stream has stopped (or has been cancelled)

#### See Also

* Sum Window
