## Merge Records

This step merges adjacent records based on a discriminator field. 
If the discriminator field is empty, then all records are merged into a single
output record.

In this step, merging is a shallow operation - only the top-level items are considered.
Later records will overwrite earlier records that happen to have the same top-level fields.
For example,  

```
Record #1: { "a": 1, "b": {"c": 2} }
```
 
```
Record #2: { "b": {"d": 3}, "e": 4 }
```

The result of the merge will be

```
Record Out: { "a": 1, "b": {"d": 3}, "e": 4 }
```

For efficiency, there is no attempt to merge the c & d inside b.


### Structure
N => 0..1 (no discriminator) or  N => N with a discriminator field

### Input
Any records can be input - the discriminator is optional, even if specified.

### Parameters
* Discriminator Field (optional) - the field used for "chunking" groups of records together for merging.

### Output
A new record for each chunk of input records with the fields merged.

#### Notes
* This step provides only a top-level merge with overwrite of child values. 
For fastest results, there is no deep scan and no attempt to concat arrays or 
merge child objects.

* Only adjacent records will be merged. If a record with discriminator value "A" 
is followed by another with "B" then that marks the end of the "A" chunk. Another
record further on which has "A" will be treated as a separate chunk as it is not adjacent.

#### See Also
* Flat Concat provides the ability to join within a record rather than across records.
