## Change Field Types

This step converts multiple field values to other types. It is the equivalent of multiple Change Field Type steps, all in one.

The available target types are: BinaryUTF8, Boolean, DateTime, Decimal128, Double, Int32, Int64, String

### Structure
1 => 1

### Input
There are no constraints on input - the conversion fields need not exist.

### Parameters
These parameters can be repeated multiple times, to change several fields in one step.

* `Convert Field` - The name of the field to convert from

* `To` - The name of the type to convert the value to

### Output
The input record with fields converted, where possible


#### Notes
* Type conversion will only be successful with appropriate input: `"123"` to Double will give `123.0`, but `"ABC"` to Double will remain `"ABC"`.

* BinaryUTF8 is the result of converting the type to a String (if it isn't already) and then encoding that String as a UTF-8 byte array. 
The primary use of this is for outputting strings to a file, without any additional structure (eg. wrapped as JSON or formatted as CSV).

#### See Also
* Change Field Type
* Change RegEx Field Types

