## Pivot Fields

This step retains turns columns identified by a regular expression into fields in outgoing records. 
If three fields of input match the regular expression, there will be three records output, in each 
output record a different column and value will be inserted.

This step behaves similar to Unwrap, but for multiple columns, rather than items in an array. 


### Structure
1 => N

### Input
There is no constraint on the input records

### Parameters

* Pivot Fields RegEx: The regular expression to identify field names that should be pivoted in the output

* Name Field: The name of the string field to hold the name of the column being pivoted

* Value Field: The name of the field to hold the value of the column being pivoted

### Output

The input record will be output one or more times with the retained fields merged with a single name/value from the pivoted fields.

### Example:

With this input:

```
{ "demo": 1, "of": 2, "this": 3, "and": 4, "that": [5,6,7] }  
```

A regular expression `th.*` with name field "name" and value field "value" would produce this output:

```
{ "demo": 1, "of": 2, "and": 4, "name": "this", "value": 3 }
{ "demo": 1, "of": 2, "and": 4, "name": "that", "value": [5,6,7 }
```


#### Notes

* If no fields match the regular expression, a single record is output, but it has no name field or value field.

* The order of records output from a single input record is undefined

#### See Also
* Unwrap
