## Run Job

This step allows running a Job (an ETL Chain) in the same way that the Scheduler does. 
In other words, you can call any chain in any chainset. The result is not the records from that chain, but the
job results - ie. status, recordCount etc. Therefore this step is a controller for other chains, but is not
for directly passing records between chainsets.  

### Structure
1 => 1

### Input
The input record contains fields which hold the ChainSet Name, Chain Name and Parameters (nested oject)

### Parameters
* `Chain Set Field` - the field in the incoming record holding the name of the ChainSet to be called

* `Chain Name` - the field in the incoming record holding the name of the Chain to be called

* `Parameters Field` - the field in the incoming record holding the parameters (a nested document) to be passed with the call

* `Continue on Error` - true if the remaining records should be processed after a called chain fails, else false to stop on error

### Output
The input record with a new nested `runJob` object holding:

* `jobId` - The id of the job that was run

* `started` - When the job started (timestamp)

* `stopped` - When the job finished (timestamp)

* `recordCount` - How many records were produced at the end of the chain

* `status` - The completion status of the job: "Completed" means success, anything else is a failure.


#### Notes
* The user's access rights determine which chainsets can be used.

* You should check the runJob.status of each record to determine whether the chain completed fully. If a job fails and 
Continue on Error is set to false, the chain will finish at this point, with the last record showing the failure (status).
This chain is considered to have completed successfully.

#### See Also
* Chain Call (for calling chains within the same chain set)
