## Sum Window

This step sums values from the incoming records that occur within a sliding window of time, adding the sum to each record emitted.

For example, if records arrive every 2 seconds, and the count is set to five seconds you will see:

```
         Value  Sum
00:00 A  2      2
00:02 B  1      3
00:04 C  3      6 
00:06 D  0      4
00:08 E  1      4
00:10 F  1      2
...
```

In other words, at step D, we look back at the records seen since (00:06-5) which is 00:01. There have been three records (B,C,D) so the result is the sum of those values (1,3,0) == 4.

### Structure
1 => 1

### Input
No special requirements

### Parameters

* `Number Field` - the field holding numberic values to sum
* `Window (secs)` - the size of the window in seconds
* `Sum Output` - the name of the field to hold the double result (BsonDouble)

### Output
Each record will be passed through with the addition of a new field named from `Sum Output` containing a double value of the sum of the value extracted from each record the step has seen within the time window, including the current record. 

#### Notes

* The `Number Field` value can be any numeric type (int32, int64, double or decimal). All will be summed as double, regardless of the input type to ensure a consistent output.  Any records missing a valid number field will not be counted.

* The Sum Window step can be used as a replacement for the Count Window step to ensure there is always an up-to-date value. For example, whereas Count always treats each record as `1`, the Sum can have records with `1` and `0`. This allows
the injection of `0` records at regular intervals which will not affect the sum, but ensure the count is recent.

#### See Also

* Count Window

* Idle Json Record
