## Take Last Records

This step takes all records from upstream, but only passes on the last `Count` records received. 
Unlike `Take First`, this consumes all records and is particularly useful when you want to keep track of the last
record processed, so you know where to resume next time.

### Structure
N => 0..Count

### Input
No input requuirements

### Parameters
* Count - The maximum number of records to pass through.

### Output
No more than `Count` records will be output. Of course, there may be less than Count, 
if the upstream steps complete before supplying that many.

#### Notes
* Useful to limit test data while revising logic - you can always disable the step later when
you need to process the full data. Prefer `Take First` if you don't want all upstream records to be consumed.

#### See Also
* Take First Records

* Drop Records
