## Test Expect

This step compares the incoming records with the expected records and reports whether the test passes.

In the case of failure, the actual and expected results are attached to the output. 

### Structure
N => 1

### Input
Any input is allowed

### Parameters
* 'JSON' - The Json record (or array of records) that the previous steps are expected to produce

* 'JSON Structure' - whether the JSON produced from the BSON records should be in relaxed or extended form 

### Output
This step will produce a single record out which contains:

* 'chain' - the chain that has been run (useful when called from Test Suite)

* 'pass' - a boolean indicating success or failure

* 'message' - a message providing more details about the success or failure of the test

Other supporting information will be added in the case of failure, depending on the nature of the failure.

#### Notes

* The difference between relaxed and extended (sometimes called canonical) JSON is due to the lack of 
data types and precision in JavaScript and hence JSON. 
The internal format has a BsonDateTime structure for timestamps. This is rendered into JSON 
differently depending on the chosen mode. The same is true of Long (64 bit) numbers 
and Decimal128 etc. 

   For example, in Extended mode, a timestamp is: '''{"$date": {"$numberLong": "<millis>"}}''' whereas 
   in Relaxed mode it is: '''{"$date": "<ISO-8601 Date/Time Format>"}'''

* For full details on relaxed and extended (canonical) modes, see: [MongoDB](https://docs.mongodb.com/manual/reference/mongodb-extended-json/).  

#### See Also

* Test Suite
