## Test Log Progress

This step writes to the job log after processing a number of records. 

It is used to provide some throughput timings, so you can see how long the system
takes to process a batch of records. As records flow through the steps one by one,
the system is usually processing multiple records in different steps concurrently.

### Structure
1 => 1

### Input
Any input is allowed - records are not processed by this step

### Parameters
* `Records Per Log` - how many records to count before outputting a log item 

### Output
The input record is passed through unchanged

#### Notes
* The ETL steps run concurrently, with records passing through the chain one by one. This
will typically lead to some "queueing" at slower steps as upstream records are waiting 
for the slow step to complete the previous record. The overall order of records is always
maintained, so a "back-pressure" mechanism slows the upstream to a speed that the 
downstream steps can handle. This saves having huge queues in memory for the slow steps.
For example, when reading from JDBC, records are only read from the result set as fast
as they can be processed, minimising the memory use. Logically, a chain with ten steps
would only have ten records in memory, as each step only handles one record at a time.

#### See Also
* Other Test steps
