## Test Sleep

This step inserts a Sleep into the chain. This can be useful when working with external systems which 
are asynchronous and need a certain time to complete an operation. It can also be useful when working with
external systems that might throttle responses - eg. no more than six requests per minute can be enforced by
a sleep of 10 seconds. (Consider Timer as an alternative for this, though.)

Sleep is also useful during testing, for example to simulate a slow device or to force part of the system
to timeout to confirm the expected behaviour. 

### Structure
1 => 1

### Input
Any input

### Parameters

* `Duration (Secs)` - how long to sleep for

* `Log` - whether to insert a line into the job log recording the sleep

### Output
The input records will be passed through unchanged, just with a delay

#### Notes
* Sleep applies to every record passed through. Each record will be held for a fixed duration before
being passed through unchanged to the next step.

#### See Also

* Test Sleep (Field)

* Timer

* Other Test steps
