## JSON Schema Validation

This step will validate that a record when converted to JSON matches the expected JSON Schema.

### Structure
1 => 1

### Input
* No special requirements

### Parameters
* `Schema URL` - The location (URL) of the JSON Schema to use for testing

### Output
If the record is validated successfully against the schema, the record is passed through unchanged.

If the record has validation errors, each error is appended to the validationIssues array.

#### Notes

* Unlike most other validation steps, this one can add multiple validationIssues to the array as a schema
is checking the entire record.
  
* Use a repository: URL protocol to access schema files within the repository, for example:

```
repository:/User/admin/demo-schema.json
```

* Avoid using local file system (file: URLs) as they are not easily scalable when more servers are added)

#### See Also

* 
