## MongoDB Contains Value

This step will check whether the value of a field matches one of the values in a specific MongoDB collection field.

Use this step rather than Lookup Values if there are lots of values. This step is slower because it tests each record
one by one, whereas Lookup Values loads all values once for fast comparison. Loading all values is fast if there are
less values than you are comparing with, but can run out of memory as the number of distinct values grows. 

Use Lookup Values where you have small numbers, eg. "Sales", "Marketing", "Finance".

Use Contains Value where you have large numbers, eg. birth dates, identity card numbers etc.

### Structure
1 => 1

### Input
* No special requirements

### Parameters
* `Field` - The field to validate

* `Database` - The MongoDB database holding the collection to read

* `Collection` - The collection holding the allowed values for the field

* `Collection Field` - The field with the allowed values

### Output

If the field matches one of the values loaded from the MongoDB collection field, the record is passed through unchanged.

If the field does not match a loaded value, a `validationIssue` is added.

If the field does not exist, a `validationIssue` is added.

#### Notes

This step works on all MongoDB types - so whether your field holds an integer or a string etc. you can use this
check. Note that an Int32 is different from an Int64, and both the type and value must match.

#### See Also

* String Values
* MongoDB Lookup Values
