## Xlsx Password Protect

This step takes incoming bytes representing an XLSX spreadsheet file and applies password protection to the data.

Password protection usually follows some step which produces XLSX output - eg. an XLSX Writer, 
or even a File Reader which has loaded an XLSX file from disk.

### Structure
1 => 1

### Input
The input record should contain a binary field called bytes which represents a valid XLSX spreadsheet.

### Parameters
* `Password` - The password to use when password protecting the file. This can use {enc} syntax to avoid accidental 
exposing the password.

### Output
The input record with fields set:

* `bytes` - A password protected version of the bytes field from the incoming record

#### Notes
* Password strings are trimmed, so whitespace is removed from the start and end.

* An empty password will be ignored - the incoming document will not be altered.

* Don't use this step immediately after XLSX File Writer, because that doesn't output bytes - it writes directly to the file.
If you want to apply this you will need to have a File Reader in between to get the bytes back into memory. 
It is probably better to use XLSX Writer (which produces bytes) and then follow this step with File Writer, 
which writes the bytes after password protection to disk.

#### See Also
* Xlsx Password Protect (Field)
