## Xlsx Password Unprotect

This step takes incoming bytes representing an encrypted XLSX spreadsheet file and removes password protection from the data.

### Structure
1 => 1

### Input
The input record should contain a binary field called bytes which represents a valid XLSX spreadsheet.

### Parameters
* `Password` - The password to use to unprotect the file. This can use {enc} syntax to avoid accidental 
exposing the password.

### Output
The input record with fields set:

* `bytes` - An unprotected version of the bytes field from the incoming record

#### Notes
* Password strings are trimmed, so whitespace is removed from the start and end.

* An empty password will be ignored - the incoming document will not be altered.

#### See Also
* Xlsx Password Protect
