## XML Tree Reader

This step converts incoming XML into records for subsequent processing.

To use this step, you need to define the root for navigation to construct each record. 

Unlike XML Reader, here we build trees within the records, following the XML tree structure.

Here's an example:

Input:
```
<?xml version="1.0" encoding="UTF-8"?>
<demo>
  <group name="A">
    <record name="First">Value1</record>
    <record name="Second">Value2</record>
  </group>
  <group name="B">
    <record name="First">Value3</record>
    <record name="Second">Value4</record>
    <record name="Third">Value5</record>
  </group>
</demo>
```

We can choose our Roots as `/demo/group` in which case we get two records out. Converted to JSON they look like this:
```
{
  "group": {
    "name": "A", 
    "record": [{"name": "First", "_text": "Value1"}, {"name": "Second", "_text": "Value2"}]
  }
}
{
  "group": {
    "name": "B", 
    "record": [{"name": "First", "_text": "Value3"}, {"name": "Second", "_text": "Value4"}, {"name": "Third", "_text": "Value5"}]
  }
}
```

Alternatively, we can choose our Roots as `/demo/group/record` in which case we get five records out:
```
{"record": {"name": "First", "_text": "Value1"}}
{"record": {"name": "Second", "_text": "Value2"}}
{"record": {"name": "First", "_text": "Value3"}}
{"record": {"name": "Second", "_text": "Value4"}}
{"record": {"name": "Third", "_text": "Value5"}}
```

If you choose `/*` as your root (or `/demo`) you will get the entire XML as a single JSON record.

### Structure
1 => N

### Input
The `bytes` field on each record received will be parsed into XML

### Parameters
* `Roots` - the xpath which is used to identify the roots of the extraction process. Each root identified produces one record out.

### Output
A record will be output for each root identified, with the subtree expanded into the JSON/BSON document structure.

#### Notes

XML does not identify number types, so all field values will be strings

#### See Also

* XML Reader
 
* XSLT Processor
