## XSLT Processor

This step applies XSLT Transformations to XML producing a string (XML) output.

This help cannot teach you how to write XSLT, so here's a simple input, transform and output to get you started.

Input:
```
<?xml version="1.0" encoding="UTF-8"?>
<demo>
  <group name="A">
    <record name="First">Value1</record>
    <record name="Second">Value2</record>
  </group>
  <group name="B">
    <record name="First">Value3</record>
    <record name="Second">Value4</record>
    <record name="Third">Value5</record>
  </group>
</demo>
```

XSLT:
```
<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <Summary>
      <xsl:apply-templates/>
    </Summary>
  </xsl:template>

  <xsl:template match="group">
    <Info>Group <xsl:value-of select="@name"/> has <xsl:value-of select="count(record)"/> records</Info>
  </xsl:template>

</xsl:stylesheet>
```

Output:
```
<?xml version="1.0" encoding="UTF-8"?><Summary>
  <Info>Group A has 2 records</Info> 
  <Info>Group B has 3 records</Info>
</Summary>
```

### Structure
1 => 1

### Input
A record holding XML to be transformed in a field called `bytes` - typically this will be binary data, eg. loaded from a file, 
but to be helpful, this step will also accept string content in the `bytes` field.

### Parameters
* `XSLT Field` - the name of the field which holds the XSLT transformations. The field value may contain either binary or string contents.

* `Result Field` - the name of the binary field to hold the output of the transformations

* `Indent` - whether to indent the XML - support for this depends on the specific XSLT engine used by your JVM

* `Omit XML Prefix` - whether to omit the ```<?xml version="1.0" encoding="UTF-8"?>``` from the first line

### Output
For each incoming record, an output record will be produced which contains an extra `Result Field` holding the transformed XML.

#### Notes
* If either the XML or XSLT content is invalid, the job log will contain a message and no result will be produced

* The output is binary so that it can be passed directly to other XML processing steps, or written to disk

#### See Also

* XML Reader
