/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech;

import com.elixirtech.HttpClientResponse;
import com.elixirtech.HttpClientResponse$;
import com.elixirtech.HttpExecutor$;
import com.elixirtech.Util$;
import com.elixirtech.repclient.LogMessage;
import com.elixirtech.repclient.LogMessage$Error$;
import com.elixirtech.repclient.LogMessage$ErrorEx$;
import com.elixirtech.repclient.LoggingHelper;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HttpClientRequest$
implements LoggingHelper,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HttpClientRequest$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Charset UTF_8;
    private static final byte[] EmptyBytes;
    private static Option<Timeout> optResponseTimeout;
    public static final HttpClientRequest$ MODULE$;

    private HttpClientRequest$() {
    }

    static {
        MODULE$ = new HttpClientRequest$();
        LoggingHelper.$init$(MODULE$);
        UTF_8 = StandardCharsets.UTF_8;
        EmptyBytes = new byte[0];
        optResponseTimeout = None$.MODULE$;
    }

    @Override
    public Logger log() {
        Object object = this.log$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.log$(this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClientRequest$.class);
    }

    public Charset UTF_8() {
        return UTF_8;
    }

    public byte[] EmptyBytes() {
        return EmptyBytes;
    }

    public void setResponseTimeout(Option<Timeout> t) {
        optResponseTimeout = t;
    }

    public HttpClientResponse get(String uriString, Map<String, String> data, Map<String, String> headers) {
        Either<LogMessage, URIBuilder> either = this.buildURI(uriString);
        if (either instanceof Right) {
            URIBuilder uriBuilder = (URIBuilder)((Right)either).value();
            data.foreach((Function1 & Serializable)kv -> uriBuilder.addParameter((String)kv._1(), (String)kv._2()));
            Request request = Request.get((URI)uriBuilder.build());
            headers.foreach((Function1 & Serializable)kv -> request.addHeader((String)kv._1(), (String)kv._2()));
            return this.buildResponse(this.exec(request));
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            msg.log(this);
            throw new RuntimeException(new StringBuilder(30).append("HttpClientRequest get failed: ").append(msg.msg()).toString());
        }
        throw new MatchError(either);
    }

    public Map<String, String> get$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> get$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public HttpClientResponse postForm(String uriString, Map<String, String> data, Map<String, String> headers) {
        Either<LogMessage, URIBuilder> either = this.buildURI(uriString);
        if (either instanceof Right) {
            URIBuilder uriBuilder = (URIBuilder)((Right)either).value();
            scala.collection.immutable.Iterable nameValuePairs = (scala.collection.immutable.Iterable)data.map((Function1 & Serializable)kv -> new BasicNameValuePair((String)kv._1(), (String)kv._2()));
            Request request = Request.post((URI)uriBuilder.build()).bodyForm(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)nameValuePairs).asJava());
            headers.foreach((Function1 & Serializable)kv -> request.addHeader((String)kv._1(), (String)kv._2()));
            return this.buildResponse(this.exec(request));
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            msg.log(this);
            throw new RuntimeException(new StringBuilder(31).append("HttpClientRequest post failed: ").append(msg.msg()).toString());
        }
        throw new MatchError(either);
    }

    public Map<String, String> postForm$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> postForm$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public HttpClientResponse postBytes(String uriString, byte[] data, Map<String, String> headers) {
        Either<LogMessage, URIBuilder> either = this.buildURI(uriString);
        if (either instanceof Right) {
            URIBuilder uriBuilder = (URIBuilder)((Right)either).value();
            Request request = Request.post((URI)uriBuilder.build()).bodyByteArray(data);
            headers.foreach((Function1 & Serializable)kv -> request.addHeader((String)kv._1(), (String)kv._2()));
            return this.buildResponse(this.exec(request));
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            msg.log(this);
            throw new RuntimeException(new StringBuilder(31).append("HttpClientRequest post failed: ").append(msg.msg()).toString());
        }
        throw new MatchError(either);
    }

    public Map<String, String> postBytes$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public HttpClientResponse buildResponse(Response response) {
        HttpResponse ret = response.returnResponse();
        Object object = Predef$.MODULE$.refArrayOps((Object[])ret.getHeaders());
        return HttpClientResponse$.MODULE$.apply(ret.getCode(), (byte[])this.getEntity(ret).getOrElse(HttpClientRequest$::buildResponse$$anonfun$1), (Map<String, String>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)h -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.getValue());
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Option<byte[]> getEntity(HttpResponse response) {
        HttpResponse httpResponse = response;
        if (httpResponse instanceof HttpEntityContainer) {
            HttpEntityContainer c = (HttpEntityContainer)httpResponse;
            return Option$.MODULE$.apply((Object)c.getEntity()).map((Function1 & Serializable)e -> {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Util$.MODULE$.copy(e.getContent(), baos);
                return baos.toByteArray();
            });
        }
        return None$.MODULE$;
    }

    public Either<LogMessage, URIBuilder> buildURI(String uriString) {
        Try try_ = Try$.MODULE$.apply(() -> HttpClientRequest$.buildURI$$anonfun$1(uriString));
        if (try_ instanceof Success) {
            URIBuilder uriBuilder = (URIBuilder)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)uriBuilder);
        }
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof URISyntaxException) {
                URISyntaxException ex = (URISyntaxException)throwable;
                return package$.MODULE$.Left().apply((Object)LogMessage$Error$.MODULE$.apply(new StringBuilder(1).append(uriString).append(" ").append(ex).toString()));
            }
            Throwable ex = throwable;
            return package$.MODULE$.Left().apply((Object)LogMessage$ErrorEx$.MODULE$.apply(new StringBuilder(1).append(uriString).append(" ").append(ex).toString(), ex));
        }
        throw new MatchError((Object)try_);
    }

    public Response exec(Request request) {
        return this.setResponseTimeout(request).execute(HttpExecutor$.MODULE$.Client());
    }

    public Request setResponseTimeout(Request request) {
        return (Request)optResponseTimeout.map((Function1 & Serializable)x$0 -> request.responseTimeout(x$0)).getOrElse(() -> HttpClientRequest$.setResponseTimeout$$anonfun$2(request));
    }

    private static final byte[] buildResponse$$anonfun$1() {
        return MODULE$.EmptyBytes();
    }

    private static final URIBuilder buildURI$$anonfun$1(String uriString$1) {
        return new URIBuilder(uriString$1);
    }

    private static final Request setResponseTimeout$$anonfun$2(Request request$5) {
        return request$5;
    }
}

