/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech;

import com.elixirtech.HttpClientRequest$;
import com.elixirtech.HttpClientResponse;
import com.elixirtech.RequestBuilder;
import com.elixirtech.RequestInfo;
import com.elixirtech.UserPassword;
import com.elixirtech.UserPasswordRequestBuilder$A2021Response$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.json4s.DefaultFormats$;
import org.json4s.JArray;
import org.json4s.JArray$;
import org.json4s.JNothing$;
import org.json4s.JString;
import org.json4s.JString$;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.native.JsonParser$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class UserPasswordRequestBuilder
implements RequestBuilder {
    private final String baseUrl;
    private final UserPassword up;
    private final String cookieValue;
    private final DefaultFormats$ formats;

    public UserPasswordRequestBuilder(String baseUrl, UserPassword up) {
        this.baseUrl = baseUrl;
        this.up = up;
        this.cookieValue = this.authenticate();
        this.formats = DefaultFormats$.MODULE$;
    }

    public String cookieValue() {
        return this.cookieValue;
    }

    public DefaultFormats$ formats() {
        return this.formats;
    }

    @Override
    public RequestInfo apply(RequestInfo ri) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Cookie");
        Map map = (Map)ri.headers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.cookieValue()));
        String string2 = ri.copy$default$1();
        return ri.copy(string2, (Map<String, String>)map);
    }

    public String authenticate() {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"username");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.up.user());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"password");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.up.password());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"totp");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, this.up.totp().getOrElse(UserPasswordRequestBuilder::$anonfun$1));
        Map body = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = HttpClientRequest$.MODULE$.postForm(new StringBuilder(20).append(this.baseUrl).append("/remote-access/login").toString(), (Map<String, String>)body, HttpClientRequest$.MODULE$.postForm$default$3());
        if (response.statusCode() != 200) {
            throw new IOException("Access Denied");
        }
        String responseText = new String(response.body(), StandardCharsets.UTF_8);
        Either<String, A2021Response> either = this.decode(responseText);
        if (either instanceof Right) {
            A2021Response resp = (A2021Response)((Right)either).value();
            return new StringBuilder(1).append(resp.cookieName()).append("=").append(resp.cookieValue()).toString();
        }
        if (either instanceof Left) {
            String err = (String)((Left)either).value();
            throw new IOException(new StringBuilder(2).append(err).append(": ").append(responseText).toString());
        }
        throw new MatchError(either);
    }

    public Either<String, A2021Response> decode(String s) {
        return this.getJson(s).flatMap((Function1 & Serializable)json -> this.getString((JValue)json, "id").flatMap((Function1 & Serializable)id -> this.getString((JValue)json, "username").flatMap((Function1 & Serializable)username -> this.getString((JValue)json, "email").flatMap((Function1 & Serializable)email -> this.getJStringSet((JValue)json, "roles").flatMap((Function1 & Serializable)roles -> this.getJStringSet((JValue)json, "privileges").flatMap((Function1 & Serializable)privileges -> this.getString((JValue)json, "cookieName").flatMap((Function1 & Serializable)cookieName -> this.getString((JValue)json, "cookieValue").map((Function1 & Serializable)cookieValue -> UserPasswordRequestBuilder$A2021Response$.MODULE$.apply((String)id, (String)username, (String)email, (Set<String>)roles, (Set<String>)privileges, (String)cookieName, (String)cookieValue)))))))));
    }

    public Either<String, Set<String>> getJStringSet(JValue json, String s) {
        JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(json), s);
        if (jValue instanceof JArray) {
            List list;
            JArray jArray = JArray$.MODULE$.unapply((JArray)jValue);
            List set = list = jArray._1();
            return this.extractString((List<JValue>)set);
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(23).append("Unable to find ").append(s).append(" in json").toString());
    }

    public Either<String, Set<String>> extractString(List<JValue> value) {
        List result = value.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(JValue x) {
                JValue jValue = x;
                if (jValue instanceof JString) {
                    JString js = (JString)jValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(JValue x, Function1 function1) {
                JValue jValue = x;
                if (jValue instanceof JString) {
                    JString js = (JString)jValue;
                    return js.s();
                }
                return function1.apply((Object)x);
            }
        });
        if (result.length() != value.length()) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(34).append("Unable to extract string from set ").append(value).toString());
        }
        return package$.MODULE$.Right().apply((Object)result.toSet());
    }

    public Either<String, String> getString(JValue json, String s) {
        JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(json), s);
        if (jValue instanceof JString) {
            String string;
            JString jString = JString$.MODULE$.unapply((JString)jValue);
            String str = string = jString._1();
            return package$.MODULE$.Right().apply((Object)str);
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(23).append("Unable to find ").append(s).append(" in Json").toString());
    }

    public Either<String, JValue> getJson(String s) {
        JValue parse = JsonParser$.MODULE$.parse(s);
        JValue jValue = parse;
        if (JNothing$.MODULE$.equals(jValue)) {
            return package$.MODULE$.Left().apply((Object)"Unable to parse response as Json");
        }
        return package$.MODULE$.Right().apply((Object)parse);
    }

    private static final String $anonfun$1() {
        return "";
    }

    public static final class A2021Response
    implements Product,
    Serializable {
        private final String id;
        private final String username;
        private final String email;
        private final Set roles;
        private final Set privileges;
        private final String cookieName;
        private final String cookieValue;

        public static A2021Response apply(String string, String string2, String string3, Set<String> set, Set<String> set2, String string4, String string5) {
            return UserPasswordRequestBuilder$A2021Response$.MODULE$.apply(string, string2, string3, set, set2, string4, string5);
        }

        public static A2021Response fromProduct(Product product) {
            return UserPasswordRequestBuilder$A2021Response$.MODULE$.fromProduct(product);
        }

        public static A2021Response unapply(A2021Response a2021Response) {
            return UserPasswordRequestBuilder$A2021Response$.MODULE$.unapply(a2021Response);
        }

        public A2021Response(String id, String username, String email, Set<String> roles, Set<String> privileges, String cookieName, String cookieValue) {
            this.id = id;
            this.username = username;
            this.email = email;
            this.roles = roles;
            this.privileges = privileges;
            this.cookieName = cookieName;
            this.cookieValue = cookieValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof A2021Response)) return false;
            A2021Response a2021Response = (A2021Response)object;
            String string = this.id();
            String string2 = a2021Response.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.username();
            String string4 = a2021Response.username();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.email();
            String string6 = a2021Response.email();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Set<String> set = this.roles();
            Set<String> set2 = a2021Response.roles();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<String> set3 = this.privileges();
            Set<String> set4 = a2021Response.privileges();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            String string7 = this.cookieName();
            String string8 = a2021Response.cookieName();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.cookieValue();
            String string10 = a2021Response.cookieValue();
            if (string9 == null) {
                if (string10 == null) return true;
                return false;
            } else {
                if (!string9.equals(string10)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof A2021Response;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "A2021Response";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "username";
                }
                case 2: {
                    return "email";
                }
                case 3: {
                    return "roles";
                }
                case 4: {
                    return "privileges";
                }
                case 5: {
                    return "cookieName";
                }
                case 6: {
                    return "cookieValue";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String username() {
            return this.username;
        }

        public String email() {
            return this.email;
        }

        public Set<String> roles() {
            return this.roles;
        }

        public Set<String> privileges() {
            return this.privileges;
        }

        public String cookieName() {
            return this.cookieName;
        }

        public String cookieValue() {
            return this.cookieValue;
        }

        public A2021Response copy(String id, String username, String email, Set<String> roles, Set<String> privileges, String cookieName, String cookieValue) {
            return new A2021Response(id, username, email, roles, privileges, cookieName, cookieValue);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.username();
        }

        public String copy$default$3() {
            return this.email();
        }

        public Set<String> copy$default$4() {
            return this.roles();
        }

        public Set<String> copy$default$5() {
            return this.privileges();
        }

        public String copy$default$6() {
            return this.cookieName();
        }

        public String copy$default$7() {
            return this.cookieValue();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.username();
        }

        public String _3() {
            return this.email();
        }

        public Set<String> _4() {
            return this.roles();
        }

        public Set<String> _5() {
            return this.privileges();
        }

        public String _6() {
            return this.cookieName();
        }

        public String _7() {
            return this.cookieValue();
        }
    }
}

