/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ers2.client;

import com.elixirtech.ers2.client.ERSClient;
import com.elixirtech.report2.runtime.IJobInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ERSClientCommand$
implements Serializable {
    public static final ERSClientCommand$ MODULE$ = new ERSClientCommand$();

    private ERSClientCommand$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ERSClientCommand$.class);
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        parser.accepts("host", "host name or IP, default localhost").withRequiredArg().ofType(String.class);
        parser.accepts("port", "port number, default 8080").withRequiredArg().ofType(Integer.class);
        parser.accepts("user", "user name (required)").withRequiredArg().ofType(String.class);
        parser.accepts("password", "user password (required)").withRequiredArg().ofType(String.class);
        parser.accepts("secure", "use if the server is running in secure mode");
        parser.accepts("mimetype", "mimetype (required)").withRequiredArg().ofType(String.class);
        parser.accepts("report", "full report path (required)").withRequiredArg().ofType(String.class);
        parser.accepts("param", "name=value parameter (multiple param options allowed)").withRequiredArg().ofType(String.class);
        parser.accepts("output", "output file (required)").withRequiredArg().ofType(String.class);
        parser.accepts("help", "this help text");
        System.out.println("Elixir Repertoire Client Report Rendering Utility");
        Try try_ = Try$.MODULE$.apply(() -> ERSClientCommand$.main$$anonfun$1(parser, args));
        if (try_ instanceof Success) {
            OptionSet options = (OptionSet)((Success)try_).value();
            this.run(args, parser, options);
            return;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            Object object = Predef$.MODULE$.refArrayOps((Object[])args);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)arg -> System.out.print(new StringBuilder(3).append("\"").append((String)arg).append("\" ").toString()));
            System.out.println();
            System.out.println(new StringBuilder(7).append("Error: ").append(ex).toString());
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public void run(String[] args, OptionParser parser, OptionSet options) {
        if (args.length == 0 || options.hasArgument("help")) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        boolean failed = false;
        if (!options.hasArgument("user")) {
            System.out.println("User required");
            failed = true;
        }
        if (!options.hasArgument("password")) {
            System.out.println("Password required");
            failed = true;
        }
        if (!options.hasArgument("mimetype")) {
            System.out.println("Mimetype required");
            failed = true;
        }
        if (!options.hasArgument("report")) {
            System.out.println("Report required");
            failed = true;
        }
        if (!options.hasArgument("output")) {
            System.out.println("Output required");
            failed = true;
        }
        if (failed) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        this.render(options);
    }

    private void render(OptionSet options) {
        String host = options.hasArgument("host") ? String.valueOf(options.valueOf("host")) : "localhost";
        String port = options.hasArgument("port") ? String.valueOf(options.valueOf("port")) : "8080";
        boolean secure = options.has("secure");
        String url = secure ? new StringBuilder(9).append("https://").append(host).append(":").append(port).toString() : new StringBuilder(8).append("http://").append(host).append(":").append(port).toString();
        String user = String.valueOf(options.valueOf("user"));
        String password = String.valueOf(options.valueOf("password"));
        ERSClient ersClient = new ERSClient(url, user, password);
        File f = new File(String.valueOf(options.valueOf("output"))).getAbsoluteFile();
        File parentFile = f.getParentFile();
        Object object = !parentFile.exists() ? BoxesRunTime.boxToBoolean((boolean)parentFile.mkdirs()) : BoxedUnit.UNIT;
        FileOutputStream fos = new FileOutputStream(f);
        try {
            String mimeType = String.valueOf(options.valueOf("mimetype"));
            String report = String.valueOf(options.valueOf("report"));
            if (!report.startsWith("/")) {
                report = new StringBuilder(1).append("/").append(report).toString();
            }
            Properties props = new Properties();
            if (options.hasArgument("param")) {
                CollectionConverters$.MODULE$.ListHasAsScala(options.valuesOf("param")).asScala().foreach((Function1 & Serializable)pair -> Some$.MODULE$.apply((Object)StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(String.valueOf(pair)), '=')).flatMap((Function1 & Serializable)kv -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])kv);
                    return ArrayOps$.MODULE$.headOption$extension(object).flatMap((Function1 & Serializable)key -> ((Option)Predef$.MODULE$.wrapRefArray((Object[])kv).lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).map((Function1 & Serializable)value -> props.put(key, value)));
                }));
            }
            IJobInfo job = ersClient.renderReport(report, mimeType, fos, props);
            fos.close();
            this.printJob(job);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-2);
        }
    }

    public void printJob(IJobInfo jobInfo) {
        int statusCode = jobInfo.getInteger("status-code");
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ERSClientCommand$.printJob$$anonfun$1(jobInfo);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ERSClientCommand$.printJob$$anonfun$2(jobInfo);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ERSClientCommand$.printJob$$anonfun$3(jobInfo);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ERSClientCommand$.printJob$$anonfun$4(jobInfo);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ERSClientCommand$.printJob$$anonfun$5(statusCode);
            return BoxedUnit.UNIT;
        });
        if (statusCode != 1) {
            System.exit(-1);
            return;
        }
    }

    private static final OptionSet main$$anonfun$1(OptionParser parser$1, String[] args$1) {
        return parser$1.parse(args$1);
    }

    private static final void printJob$$anonfun$1(IJobInfo jobInfo$1) {
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("Page Count: ").append(jobInfo$1.getInteger("page-count")).toString());
    }

    private static final void printJob$$anonfun$2(IJobInfo jobInfo$2) {
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("Record Count: ").append(jobInfo$2.getInteger("record-count")).toString());
    }

    private static final void printJob$$anonfun$3(IJobInfo jobInfo$3) {
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("Byte Size: ").append(jobInfo$3.getLong("byte-size")).toString());
    }

    private static final void printJob$$anonfun$4(IJobInfo jobInfo$4) {
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("Elapsed Time: ").append(jobInfo$4.getLong("elapsed-time")).toString());
    }

    private static final void printJob$$anonfun$5(int statusCode$1) {
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Status Code: ").append(statusCode$1).toString());
    }
}

