package demo

import ch.qos.logback.classic.{Level, Logger}
import com.elixirtech.RepertoireClient
import com.elixirtech.ers2.client.ERSClient
import com.elixirtech.report2.runtime.IJobInfo
import org.slf4j.LoggerFactory

import java.io.{ByteArrayOutputStream, File}
import java.nio.charset.StandardCharsets
import java.nio.file.Files

object ScalaDemo {
  val server = "http://localhost:1740"
  val username = "admin"
  val password = "sa"

  def main(args: Array[String]): Unit = {
    loggingInit()
    testDS1()
    testOldDS()
    testRml1()
    testRmlParam()
    testRml2()
    testOldRml()
    testDocX1()
    testDocXParam()
    testOldDocX()
    //testDocX2()
    //testDS2()
  }

  def loggingInit(): Unit = {
    LoggerFactory.getLogger(org.slf4j.Logger.ROOT_LOGGER_NAME) match {
      case root: Logger =>
        root.setLevel(Level.INFO)
        LoggerFactory.getLogger("org") match {
          case orgLogger: Logger => orgLogger.setLevel(Level.WARN)
          case _ =>
        }
      case _ =>
    }
  }

  def testDS1(): Unit = {
    val client = new RepertoireClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val info = client.generateData("/ElixirSamples/DataSource/FruitSales.ds", new java.util.HashMap[String, String](), os)
    println(new String(os.toByteArray, StandardCharsets.UTF_8))
    println(info.getEntries.mkString("Entries(", ", ", ")"))
    println("-------------------------------------------")
  }

  def testOldDS(): Unit = {
    val client = new ERSClient(server, username, password)
    val os = new ByteArrayOutputStream()
    client.generateData("/ElixirSamples/DataSource/FruitSales.ds", os, new java.util.Properties())
    println(new String(os.toByteArray, StandardCharsets.UTF_8))
    println("-------------------------------------------")
  }

  def testRml1(): Unit = {
    val client = new RepertoireClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val emptyMap = new java.util.HashMap[String, String]()
    val info = client.renderReport("/ElixirSamples/Report/RML/Master-Detail Report.rml", "application/pdf", emptyMap, emptyMap, os)
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "sample-rml1.pdf")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(info.getEntries.mkString("Entries(", ", ", ")"))
    println("-------------------------------------------")
  }

  def testRmlParam(): Unit = {
    val client = new RepertoireClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val emptyMap = new java.util.HashMap[String, String]()
    val paramMap = new java.util.HashMap[String, String]()
    paramMap.put("Staff Name", "John Doe")
    val info = client.renderReport("/ElixirSamples/Report/RML/Pivot Table.rml", "application/pdf", paramMap, emptyMap, os)
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "sample-rml1.pdf")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(info.getEntries.mkString("Entries(", ", ", ")"))
    println("-------------------------------------------")
  }

  def testRml2(): Unit = {
    val client = new RepertoireClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val emptyMap = new java.util.HashMap[String, String]()
    val info = client.renderReport(
      "/ElixirSamples/Report/RML/Master-Detail Report.rml",
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
      emptyMap,
      emptyMap,
      os
    )
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "sample-rml1.xlsx")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(info.getEntries.mkString("Entries(", ", ", ")"))
    println("-------------------------------------------")
  }

  def testOldRml(): Unit = {
    val client = new ERSClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val info = client.renderReport(
      "/ElixirSamples/Report/RML/Master-Detail Report.rml",
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
      os,
      new java.util.Properties()
    )
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "OldStyleSampleRml1.xlsx")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(s"status-code: ${info.getInteger("status-code")}")
    println("-------------------------------------------")
  }

  def testDocX1(): Unit = {
    val client = new RepertoireClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val emptyMap = new java.util.HashMap[String, String]()
    val info = client.renderDocX(
      "/ElixirSamples/Report/DocX/Customer Profile by Location.docx",
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
      emptyMap,
      os
    )
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "SampleDocX.docx")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(info.getEntries.mkString("Entries(", ", ", ")"))
    println("-------------------------------------------")
  }

  def testDocXParam(): Unit = {
    val client = new RepertoireClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val paramMap = new java.util.HashMap[String, String]()
    paramMap.put("city", "Cliffside")
    val info = client.renderDocX(
      "/ElixirSamples/Report/DocX/Customer Profile by Location.docx",
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
      paramMap,
      os
    )
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "SampleDocX.docx")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(info.getEntries.mkString("Entries(", ", ", ")"))
    println("-------------------------------------------")
  }

  def testOldDocX(): Unit = {
    val client = new ERSClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val info = client.renderDocX(
      "/ElixirSamples/Report/DocX/Customer Profile by Location.docx",
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
      os,
      new java.util.Properties()
    )
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "OldStyleSampleDocX.docx")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(s"(status-code: ${info.getInteger(IJobInfo.STATUS_CODE)}, elapsed-time: ${info
      .getLong(IJobInfo.ELAPSED_TIME)}, byte-size: ${info.getLong(IJobInfo.BYTE_SIZE)})")
    println("-------------------------------------------")
  }

  //Initially commented out as it requires a separate aspose licence
  /*def testDocX2(): Unit = {
    val client = new RepertoireClient(server, username, password)
    val os = new ByteArrayOutputStream()
    val emptyMap = new java.util.HashMap[String, String]()
    val info = client.renderDocX("/ElixirSamples/Report/DocX/Customer Profile by Location.docx", "application/pdf", emptyMap, os)
    val tmpDir = new File(System.getProperty("java.io.tmpdir"))
    val output = new File(tmpDir, "SampleDocX.pdf")
    Files.write(output.toPath, os.toByteArray)
    println(s"File rendered to ${output.getAbsolutePath}")
    println(info.getEntries.mkString("Entries(", ", ", ")"))
    println("-------------------------------------------")
  }*/

  //This function is initially commented out as it uses API token authentication
  /*def testDSWithAPIToken(): Unit = {
    val client = new RepertoireClient(server, "c532b968-fd1e-4b02-b065-48b122def059")
    val os = new ByteArrayOutputStream()
    client.generateData("/ElixirSamples/DataSource/FruitSales.ds", new java.util.HashMap[String, String](), os)
    println(new String(os.toByteArray, StandardCharsets.UTF_8))
    println("-------------------------------------------")
  }*/

}
