/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AggregateOperation;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public final class ListSearchIndexesOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private static final String STAGE_LIST_SEARCH_INDEXES = "$listSearchIndexes";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    @Nullable
    private final Boolean allowDiskUse;
    @Nullable
    private final Integer batchSize;
    @Nullable
    private final Collation collation;
    @Nullable
    private final BsonValue comment;
    @Nullable
    private final String indexName;
    private final boolean retryReads;

    public ListSearchIndexesOperation(MongoNamespace namespace, Decoder<T> decoder, @Nullable String indexName, @Nullable Integer batchSize, @Nullable Collation collation, @Nullable BsonValue comment, @Nullable Boolean allowDiskUse, boolean retryReads) {
        this.namespace = namespace;
        this.decoder = decoder;
        this.allowDiskUse = allowDiskUse;
        this.batchSize = batchSize;
        this.collation = collation;
        this.comment = comment;
        this.indexName = indexName;
        this.retryReads = retryReads;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        try {
            return this.asAggregateOperation().execute(binding);
        }
        catch (MongoCommandException exception) {
            int cursorBatchSize;
            int n = cursorBatchSize = this.batchSize == null ? 0 : this.batchSize;
            if (!CommandOperationHelper.isNamespaceError(exception)) {
                throw exception;
            }
            return SingleBatchCursor.createEmptySingleBatchCursor(exception.getServerAddress(), cursorBatchSize);
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.asAggregateOperation().executeAsync(binding, (AsyncBatchCursor<T> cursor, Throwable exception) -> {
            if (exception != null && !CommandOperationHelper.isNamespaceError(exception)) {
                callback.onResult(null, exception);
            } else if (exception != null) {
                callback.onResult(AsyncSingleBatchCursor.createEmptyAsyncSingleBatchCursor(this.batchSize == null ? 0 : this.batchSize), null);
            } else {
                callback.onResult((AsyncBatchCursor<T>)cursor, null);
            }
        });
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.asAggregateOperation().asExplainableOperation(verbosity, resultDecoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.asAggregateOperation().asAsyncExplainableOperation(verbosity, resultDecoder);
    }

    private AggregateOperation<T> asAggregateOperation() {
        BsonDocument searchDefinition = this.getSearchDefinition();
        BsonDocument listSearchIndexesStage = new BsonDocument(STAGE_LIST_SEARCH_INDEXES, (BsonValue)searchDefinition);
        return new AggregateOperation<T>(this.namespace, Collections.singletonList(listSearchIndexesStage), this.decoder).retryReads(this.retryReads).collation(this.collation).comment(this.comment).allowDiskUse(this.allowDiskUse).batchSize(this.batchSize);
    }

    @NonNull
    private BsonDocument getSearchDefinition() {
        if (this.indexName == null) {
            return new BsonDocument();
        }
        return new BsonDocument("name", (BsonValue)new BsonString(this.indexName));
    }
}

