/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class AttributeConstraint
implements Constraint {
    public static final String VERSION = "$Id: AttributeConstraint.java,v 1.3 2007-07-06 20:40:00 jon Exp $";
    protected final String anchorList;
    private final AttributeType attribute;
    private final int offset;
    private final List<Attribute> dependencies;

    public AttributeConstraint(String string, AttributeType attributeType, int n) {
        this.anchorList = string;
        this.attribute = attributeType;
        this.offset = n;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            arrayList.add(new Attribute(string2, attributeType));
        }
        this.dependencies = Collections.unmodifiableList(arrayList);
    }

    public AttributeConstraint(String string, AttributeType attributeType) {
        this(string, attributeType, 0);
    }

    @Override
    public List<Attribute> getDependencies() {
        return this.dependencies;
    }

    @Override
    public int getValue(AttributeSource attributeSource) {
        long l = 0L;
        if (this.attribute == AttributeType.BOTTOM || this.attribute == AttributeType.RIGHT || this.attribute == AttributeType.WIDTH || this.attribute == AttributeType.HEIGHT) {
            l = Integer.MIN_VALUE;
        } else if (this.attribute == AttributeType.TOP || this.attribute == AttributeType.LEFT) {
            l = Integer.MAX_VALUE;
        }
        ListIterator<Attribute> listIterator = this.dependencies.listIterator();
        while (listIterator.hasNext()) {
            Attribute attribute = listIterator.next();
            int n = attributeSource.getValue(attribute);
            if (this.attribute == AttributeType.BOTTOM || this.attribute == AttributeType.RIGHT || this.attribute == AttributeType.WIDTH || this.attribute == AttributeType.HEIGHT) {
                l = Math.max(l, (long)n);
                continue;
            }
            if (this.attribute == AttributeType.TOP || this.attribute == AttributeType.LEFT) {
                l = Math.min(l, (long)n);
                continue;
            }
            l += (long)n;
        }
        if (this.attribute == AttributeType.HORIZONTAL_CENTER || this.attribute == AttributeType.VERTICAL_CENTER) {
            l /= (long)this.dependencies.size();
        }
        return (int)l + this.offset;
    }

    public String toString() {
        return "AttributeConstraint: {anchors=" + this.anchorList + "; attribute=" + String.valueOf(this.attribute) + "; offset=" + this.offset + "}";
    }
}

