/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.ComponentSpecifications;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AttributeType {
    public static final String VERSION = "$Id: AttributeType.java,v 1.3 2009-06-21 12:14:54 jon Exp $";
    private static Set<AttributeType> allTypes = new HashSet<AttributeType>();
    private static Map<String, AttributeType> typeMap = new HashMap<String, AttributeType>();
    private static Map<AttributeAxis, Set<AttributeType>> axisTypes = new HashMap<AttributeAxis, Set<AttributeType>>();
    private final String name;
    private final AttributeAxis axis;
    public static final AttributeType LEFT = new AttributeType("left", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(RIGHT)) {
                if (componentSpecifications.hasConstraint(WIDTH)) {
                    return componentSpecifications.getAttributeValue(RIGHT) - componentSpecifications.getAttributeValue(WIDTH);
                }
                if (componentSpecifications.hasConstraint(HORIZONTAL_CENTER)) {
                    return 2 * componentSpecifications.getAttributeValue(HORIZONTAL_CENTER) - componentSpecifications.getAttributeValue(RIGHT);
                }
                return componentSpecifications.getAttributeValue(RIGHT) - componentSpecifications.getComponentWidth(bl);
            }
            if (componentSpecifications.hasConstraint(HORIZONTAL_CENTER)) {
                if (componentSpecifications.hasConstraint(WIDTH)) {
                    return componentSpecifications.getAttributeValue(HORIZONTAL_CENTER) - componentSpecifications.getAttributeValue(WIDTH) / 2;
                }
                return componentSpecifications.getAttributeValue(HORIZONTAL_CENTER) - componentSpecifications.getComponentWidth(bl) / 2;
            }
            throw new IllegalStateException(componentSpecifications.getComponentName() + ": Underconstrained attribute, " + String.valueOf(this));
        }
    };
    public static final AttributeType RIGHT = new AttributeType("right", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(LEFT)) {
                if (componentSpecifications.hasConstraint(WIDTH)) {
                    return componentSpecifications.getAttributeValue(LEFT) + componentSpecifications.getAttributeValue(WIDTH);
                }
                if (componentSpecifications.hasConstraint(HORIZONTAL_CENTER)) {
                    return 2 * componentSpecifications.getAttributeValue(HORIZONTAL_CENTER) - componentSpecifications.getAttributeValue(LEFT);
                }
                return componentSpecifications.getAttributeValue(LEFT) + componentSpecifications.getComponentWidth(bl);
            }
            if (componentSpecifications.hasConstraint(HORIZONTAL_CENTER)) {
                if (componentSpecifications.hasConstraint(WIDTH)) {
                    return componentSpecifications.getAttributeValue(HORIZONTAL_CENTER) + componentSpecifications.getAttributeValue(WIDTH) / 2;
                }
                return componentSpecifications.getAttributeValue(HORIZONTAL_CENTER) + componentSpecifications.getComponentWidth(bl) / 2;
            }
            throw new IllegalStateException(componentSpecifications.getComponentName() + ": Underconstrained attribute, " + String.valueOf(this));
        }
    };
    public static final AttributeType HORIZONTAL_CENTER = new AttributeType("horizontalCenter", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(LEFT)) {
                if (componentSpecifications.hasConstraint(WIDTH)) {
                    return componentSpecifications.getAttributeValue(LEFT) + componentSpecifications.getAttributeValue(WIDTH) / 2;
                }
                if (componentSpecifications.hasConstraint(RIGHT)) {
                    return (componentSpecifications.getAttributeValue(LEFT) + componentSpecifications.getAttributeValue(RIGHT)) / 2;
                }
                return componentSpecifications.getAttributeValue(LEFT) + componentSpecifications.getComponentWidth(bl) / 2;
            }
            if (componentSpecifications.hasConstraint(RIGHT)) {
                if (componentSpecifications.hasConstraint(WIDTH)) {
                    return componentSpecifications.getAttributeValue(RIGHT) - componentSpecifications.getAttributeValue(WIDTH) / 2;
                }
                return componentSpecifications.getAttributeValue(RIGHT) - componentSpecifications.getComponentWidth(bl) / 2;
            }
            throw new IllegalStateException(componentSpecifications.getComponentName() + ": Underconstrained attribute, " + String.valueOf(this));
        }
    };
    public static final AttributeType WIDTH = new AttributeType("width", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(LEFT)) {
                if (componentSpecifications.hasConstraint(RIGHT)) {
                    return componentSpecifications.getAttributeValue(RIGHT) - componentSpecifications.getAttributeValue(LEFT);
                }
                if (componentSpecifications.hasConstraint(HORIZONTAL_CENTER)) {
                    return 2 * (componentSpecifications.getAttributeValue(HORIZONTAL_CENTER) - componentSpecifications.getAttributeValue(LEFT));
                }
            }
            if (componentSpecifications.hasConstraint(RIGHT) && componentSpecifications.hasConstraint(HORIZONTAL_CENTER)) {
                return 2 * (componentSpecifications.getAttributeValue(RIGHT) - componentSpecifications.getAttributeValue(HORIZONTAL_CENTER));
            }
            return componentSpecifications.getComponentWidth(bl);
        }
    };
    public static final AttributeType TOP = new AttributeType("top", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(BOTTOM)) {
                if (componentSpecifications.hasConstraint(HEIGHT)) {
                    return componentSpecifications.getAttributeValue(BOTTOM) - componentSpecifications.getAttributeValue(HEIGHT);
                }
                if (componentSpecifications.hasConstraint(VERTICAL_CENTER)) {
                    return 2 * componentSpecifications.getAttributeValue(VERTICAL_CENTER) - componentSpecifications.getAttributeValue(BOTTOM);
                }
                return componentSpecifications.getAttributeValue(BOTTOM) - componentSpecifications.getComponentHeight(bl);
            }
            if (componentSpecifications.hasConstraint(VERTICAL_CENTER)) {
                if (componentSpecifications.hasConstraint(HEIGHT)) {
                    return componentSpecifications.getAttributeValue(VERTICAL_CENTER) - componentSpecifications.getAttributeValue(HEIGHT) / 2;
                }
                return componentSpecifications.getAttributeValue(VERTICAL_CENTER) - componentSpecifications.getComponentHeight(bl) / 2;
            }
            throw new IllegalStateException(componentSpecifications.getComponentName() + ": Underconstrained attribute, " + String.valueOf(this));
        }
    };
    public static final AttributeType BOTTOM = new AttributeType("bottom", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(TOP)) {
                if (componentSpecifications.hasConstraint(HEIGHT)) {
                    return componentSpecifications.getAttributeValue(TOP) + componentSpecifications.getAttributeValue(HEIGHT);
                }
                if (componentSpecifications.hasConstraint(VERTICAL_CENTER)) {
                    return 2 * componentSpecifications.getAttributeValue(VERTICAL_CENTER) - componentSpecifications.getAttributeValue(TOP);
                }
                return componentSpecifications.getAttributeValue(TOP) + componentSpecifications.getComponentHeight(bl);
            }
            if (componentSpecifications.hasConstraint(VERTICAL_CENTER)) {
                if (componentSpecifications.hasConstraint(HEIGHT)) {
                    return componentSpecifications.getAttributeValue(VERTICAL_CENTER) + componentSpecifications.getAttributeValue(HEIGHT) / 2;
                }
                return componentSpecifications.getAttributeValue(VERTICAL_CENTER) + componentSpecifications.getComponentHeight(bl) / 2;
            }
            throw new IllegalStateException(componentSpecifications.getComponentName() + ": Underconstrained attribute, " + String.valueOf(this));
        }
    };
    public static final AttributeType VERTICAL_CENTER = new AttributeType("verticalCenter", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(TOP)) {
                if (componentSpecifications.hasConstraint(HEIGHT)) {
                    return componentSpecifications.getAttributeValue(TOP) + componentSpecifications.getAttributeValue(HEIGHT) / 2;
                }
                if (componentSpecifications.hasConstraint(BOTTOM)) {
                    return (componentSpecifications.getAttributeValue(TOP) + componentSpecifications.getAttributeValue(BOTTOM)) / 2;
                }
                return componentSpecifications.getAttributeValue(TOP) + componentSpecifications.getComponentHeight(bl) / 2;
            }
            if (componentSpecifications.hasConstraint(BOTTOM)) {
                if (componentSpecifications.hasConstraint(HEIGHT)) {
                    return componentSpecifications.getAttributeValue(BOTTOM) - componentSpecifications.getAttributeValue(HEIGHT) / 2;
                }
                return componentSpecifications.getAttributeValue(BOTTOM) - componentSpecifications.getComponentHeight(bl) / 2;
            }
            throw new IllegalStateException(componentSpecifications.getComponentName() + ": Underconstrained attribute, " + String.valueOf(this));
        }
    };
    public static final AttributeType HEIGHT = new AttributeType("height", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications componentSpecifications, boolean bl) {
            if (componentSpecifications.hasConstraint(TOP)) {
                if (componentSpecifications.hasConstraint(BOTTOM)) {
                    return componentSpecifications.getAttributeValue(BOTTOM) - componentSpecifications.getAttributeValue(TOP);
                }
                if (componentSpecifications.hasConstraint(VERTICAL_CENTER)) {
                    return 2 * (componentSpecifications.getAttributeValue(VERTICAL_CENTER) - componentSpecifications.getAttributeValue(TOP));
                }
            }
            if (componentSpecifications.hasConstraint(BOTTOM) && componentSpecifications.hasConstraint(VERTICAL_CENTER)) {
                return 2 * (componentSpecifications.getAttributeValue(BOTTOM) - componentSpecifications.getAttributeValue(VERTICAL_CENTER));
            }
            return componentSpecifications.getComponentHeight(bl);
        }
    };

    public String getName() {
        return this.name;
    }

    public AttributeAxis getAxis() {
        return this.axis;
    }

    protected AttributeType(String string, AttributeAxis attributeAxis) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (attributeAxis == null) {
            throw new NullPointerException("axis must not be null");
        }
        this.name = string;
        this.axis = attributeAxis;
        allTypes.add(this);
        typeMap.put(string, this);
        Set<AttributeType> set = axisTypes.get(attributeAxis);
        if (set == null) {
            set = new HashSet<AttributeType>();
            axisTypes.put(attributeAxis, set);
        }
        set.add(this);
    }

    public static AttributeType getInstance(String string) {
        AttributeType attributeType = typeMap.get(string);
        if (attributeType == null) {
            throw new NoSuchElementException(string);
        }
        return attributeType;
    }

    public abstract int deriveValue(ComponentSpecifications var1, boolean var2);

    public static Set<AttributeType> getAllTypes() {
        return Collections.unmodifiableSet(allTypes);
    }

    public static Set<AttributeType> getAxisTypes(AttributeAxis attributeAxis) {
        Set<AttributeType> set = axisTypes.get(attributeAxis);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public String toString() {
        return "AttributeType: " + this.name + " (" + String.valueOf(this.axis) + ")";
    }
}

