/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AxisConstraint
implements Constraint {
    public static final String VERSION = "$Id: AxisConstraint.java,v 1.4 2009-06-21 12:14:54 jon Exp $";
    protected final String anchorName;
    private final AttributeAxis axis;
    private final double fraction;
    private final List<Attribute> dependencies;
    private final Attribute origin;
    private final Attribute length;

    public AxisConstraint(String string, AttributeAxis attributeAxis, double d) {
        this.anchorName = string;
        this.axis = attributeAxis;
        this.fraction = d;
        if (attributeAxis == AttributeAxis.HORIZONTAL) {
            this.origin = new Attribute(string, AttributeType.LEFT);
            this.length = new Attribute(string, AttributeType.WIDTH);
        } else {
            this.origin = new Attribute(string, AttributeType.TOP);
            this.length = new Attribute(string, AttributeType.HEIGHT);
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(2);
        arrayList.add(this.origin);
        arrayList.add(this.length);
        this.dependencies = Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<Attribute> getDependencies() {
        return this.dependencies;
    }

    @Override
    public int getValue(AttributeSource attributeSource) {
        return attributeSource.getValue(this.origin) + (int)(this.fraction * (double)attributeSource.getValue(this.length));
    }

    public String toString() {
        return "AxisConstraint: {anchor=" + this.anchorName + ", axis=" + String.valueOf(this.axis) + ", fraction=" + this.fraction + "}";
    }
}

