/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import com.brunchboy.util.swing.relativelayout.DependencyManager;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ComponentSpecifications {
    public static final String VERSION = "$Id: ComponentSpecifications.java,v 1.3 2009-06-21 12:14:54 jon Exp $";
    private final String componentName;
    private Component component;
    private Map<AttributeType, Constraint> constraints = new HashMap<AttributeType, Constraint>();
    private Map<AttributeType, Integer> values = new HashMap<AttributeType, Integer>();
    private static final Integer ZERO = 0;

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponent(Component component) {
        if (this.component != null) {
            throw new IllegalStateException(this.componentName + ": component was already set");
        }
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getAttributeValue(AttributeType attributeType) {
        Integer n = this.values.get(attributeType);
        if (n == null) {
            throw new IllegalStateException(this.componentName + ": " + String.valueOf(attributeType) + " not yet resolved");
        }
        return n;
    }

    public boolean hasConstraint(AttributeType attributeType) {
        return this.constraints.containsKey(attributeType);
    }

    public int getComponentWidth(boolean bl) {
        if (this.component != null) {
            if (bl) {
                return this.component.getMinimumSize().width;
            }
            return this.component.getPreferredSize().width;
        }
        return 0;
    }

    public int getComponentHeight(boolean bl) {
        if (this.component != null) {
            if (bl) {
                return this.component.getMinimumSize().height;
            }
            return this.component.getPreferredSize().height;
        }
        return 0;
    }

    public void setAttributeValue(AttributeType attributeType, int n) {
        if (this.values.containsKey(attributeType)) {
            throw new IllegalStateException(this.componentName + ": " + String.valueOf(attributeType) + "resolved more than once");
        }
        if (n == 0) {
            this.values.put(attributeType, ZERO);
        } else {
            this.values.put(attributeType, n);
        }
    }

    public void clearAttributeValues() {
        this.values.clear();
    }

    public ComponentSpecifications(String string) {
        this(string, null);
    }

    public ComponentSpecifications(String string, Component component) {
        this.componentName = string;
        this.component = component;
    }

    public void addConstraint(AttributeType attributeType, Constraint constraint) {
        if (attributeType == null) {
            throw new NullPointerException("type must not be null");
        }
        if (constraint == null) {
            throw new NullPointerException("constraint must not be null");
        }
        HashSet<AttributeType> hashSet = new HashSet<AttributeType>(this.constraints.keySet());
        hashSet.retainAll(AttributeType.getAxisTypes(attributeType.getAxis()));
        if (hashSet.contains(attributeType)) {
            throw new IllegalStateException(this.componentName + ": " + String.valueOf(attributeType) + " is already constrained");
        }
        if (hashSet.size() > 1) {
            throw new IllegalStateException(this.componentName + ": Cannot add " + String.valueOf(attributeType) + " constraint without overconstraining");
        }
        this.constraints.put(attributeType, constraint);
    }

    private void validateConstraints() {
        HashSet<AttributeType> hashSet = new HashSet<AttributeType>(this.constraints.keySet());
        hashSet.retainAll(AttributeType.getAxisTypes(AttributeAxis.HORIZONTAL));
        if (hashSet.size() < 1 || hashSet.size() == 1 && hashSet.contains(AttributeType.WIDTH)) {
            throw new IllegalStateException(this.componentName + " is underconstrained horizontally");
        }
        hashSet = new HashSet<AttributeType>(this.constraints.keySet());
        hashSet.retainAll(AttributeType.getAxisTypes(AttributeAxis.VERTICAL));
        if (hashSet.size() < 1 || hashSet.size() == 1 && hashSet.contains(AttributeType.HEIGHT)) {
            throw new IllegalStateException(this.componentName + " is underconstrained vertically");
        }
    }

    public void reportDependencies(DependencyManager dependencyManager) {
        Object object;
        Object object2;
        Object object3;
        this.validateConstraints();
        for (Map.Entry<AttributeType, Constraint> object42 : this.constraints.entrySet()) {
            object3 = new Attribute(this.componentName, object42.getKey());
            object2 = object42.getValue();
            object = object2.getDependencies().listIterator();
            while (object.hasNext()) {
                dependencyManager.add((Attribute)object3, (Attribute)object.next());
            }
        }
        HashSet<AttributeType> hashSet = new HashSet<AttributeType>(AttributeType.getAllTypes());
        hashSet.removeAll(this.constraints.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object3 = (AttributeType)iterator.next();
            object2 = new Attribute(this.componentName, (AttributeType)object3);
            object = new HashSet<AttributeType>(this.constraints.keySet());
            object.retainAll(AttributeType.getAxisTypes(((AttributeType)object3).getAxis()));
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                dependencyManager.add((Attribute)object2, new Attribute(this.componentName, (AttributeType)iterator2.next()));
            }
        }
    }

    public void computeAttribute(AttributeType attributeType, AttributeSource attributeSource, boolean bl, int n, int n2) {
        if (this.constraints.containsKey(attributeType)) {
            Constraint constraint = this.constraints.get(attributeType);
            this.setAttributeValue(attributeType, constraint.getValue(attributeSource));
        } else {
            this.setAttributeValue(attributeType, attributeType.deriveValue(this, bl));
        }
    }

    public void layoutComponent(int n, int n2) {
        if (this.component != null) {
            this.component.setBounds(this.getAttributeValue(AttributeType.LEFT) + n, this.getAttributeValue(AttributeType.TOP) + n2, this.getAttributeValue(AttributeType.WIDTH), this.getAttributeValue(AttributeType.HEIGHT));
        }
    }

    void setContainerSpecs(int n, int n2) {
        this.setAttributeValue(AttributeType.LEFT, 0);
        this.setAttributeValue(AttributeType.TOP, 0);
        this.setAttributeValue(AttributeType.RIGHT, n);
        this.setAttributeValue(AttributeType.WIDTH, n);
        this.setAttributeValue(AttributeType.BOTTOM, n2);
        this.setAttributeValue(AttributeType.HEIGHT, n2);
        this.setAttributeValue(AttributeType.HORIZONTAL_CENTER, n / 2);
        this.setAttributeValue(AttributeType.VERTICAL_CENTER, n2 / 2);
    }
}

