/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DependencyManager {
    public static final String VERSION = "$Id: DependencyManager.java,v 1.3 2009-06-21 12:14:54 jon Exp $";
    private Map<Attribute, Node> nodes = new HashMap<Attribute, Node>();
    public static final String ROOT_NAME = "_container";
    private boolean valid = false;
    private List<Node> roots;
    private List<Attribute> sortedNodes;

    private Node getNode(Attribute attribute) {
        Node node = this.nodes.get(attribute);
        if (node == null) {
            node = new Node(attribute);
            this.nodes.put(attribute, node);
        }
        return node;
    }

    public void add(Attribute attribute, Attribute attribute2) throws IllegalStateException {
        Node node = this.getNode(attribute2);
        this.getNode(attribute);
        if (node.hasDependent(attribute)) {
            throw new IllegalStateException(String.valueOf(attribute) + " already dependent on " + String.valueOf(attribute2));
        }
        node.addDependent(attribute);
    }

    private void resetNodes() {
        for (Node node : this.nodes.values()) {
            node.refCount = 0;
        }
    }

    private List<Node> getRootNodes() {
        this.resetNodes();
        for (Node object : this.nodes.values()) {
            for (int i = 0; i < object.size(); ++i) {
                Attribute attribute = object.getDependent(i);
                if (attribute.equals(object.attribute)) {
                    throw new IllegalStateException(String.valueOf(object) + " depends on itself");
                }
                ++this.nodes.get((Object)attribute).refCount;
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Node node : this.nodes.values()) {
            if (node.refCount != 0) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private void checkNodeForCycles(Node node, int n) {
        if (++n > this.nodes.size()) {
            throw new IllegalStateException("Cycle detected for attribute " + String.valueOf(node.attribute));
        }
        for (int i = 0; i < node.size(); ++i) {
            Attribute attribute = node.getDependent(i);
            Node node2 = this.nodes.get(attribute);
            this.checkNodeForCycles(node2, n);
        }
    }

    public void validate() {
        this.roots = this.getRootNodes();
        for (Node node : this.roots) {
            if (!node.attribute.getComponent().equals(ROOT_NAME)) {
                throw new IllegalStateException("Unresolvable dependency: " + String.valueOf(node.attribute));
            }
            this.checkNodeForCycles(node, 0);
        }
        this.valid = true;
    }

    public List<Attribute> sort() {
        if (this.sortedNodes != null) {
            return this.sortedNodes;
        }
        if (!this.valid) {
            this.validate();
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.nodes.size());
        for (Node node : this.roots) {
            this.recursiveSort(arrayList, node);
        }
        this.sortedNodes = Collections.unmodifiableList(arrayList);
        return this.sortedNodes;
    }

    private void recursiveSort(List<Attribute> list, Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Attribute attribute = node.getDependent(i);
            Node node2 = this.nodes.get(attribute);
            if (--node2.refCount != 0) continue;
            list.add(attribute);
            this.recursiveSort(list, node2);
        }
    }

    private static class Node {
        final Attribute attribute;
        List<Attribute> dependents = new LinkedList<Attribute>();
        int refCount;

        Node(Attribute attribute) {
            this.attribute = attribute;
        }

        boolean hasDependent(Attribute attribute) {
            return this.dependents.contains(attribute);
        }

        int size() {
            return this.dependents.size();
        }

        Attribute getDependent(int n) {
            return this.dependents.get(n);
        }

        void addDependent(Attribute attribute) {
            this.dependents.add(attribute);
        }
    }
}

