/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.ComponentSpecifications;
import com.brunchboy.util.swing.relativelayout.Constraint;
import com.brunchboy.util.swing.relativelayout.DependencyManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RelativeLayout
implements LayoutManager2 {
    public static final String VERSION = "$Id: RelativeLayout.java,v 1.3 2009-06-21 12:14:54 jon Exp $";
    private Map<String, ComponentSpecifications> componentSpecs = new HashMap<String, ComponentSpecifications>();
    private Map<Component, ComponentSpecifications> specsByAWTComponent = new HashMap<Component, ComponentSpecifications>();
    private DependencyManager dependencies;
    private final AttributeSource attributeSource = new AttributeSource(){

        @Override
        public int getValue(Attribute attribute) {
            ComponentSpecifications componentSpecifications = RelativeLayout.this.componentSpecs.get(attribute.getComponent());
            if (componentSpecifications == null) {
                throw new IllegalStateException("Need attribute of unknown component " + attribute.getComponent());
            }
            return componentSpecifications.getAttributeValue(attribute.getType());
        }
    };

    private ComponentSpecifications getComponentSpecifications(String string) {
        if (string == null) {
            throw new NullPointerException("Component name cannot be null");
        }
        ComponentSpecifications componentSpecifications = this.componentSpecs.get(string);
        if (componentSpecifications == null) {
            componentSpecifications = new ComponentSpecifications(string);
            this.componentSpecs.put(string, componentSpecifications);
        }
        return componentSpecifications;
    }

    private void validateComponentName(String string) {
        if ("_container".equals(string)) {
            throw new IllegalArgumentException("The name _container is reserved");
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.validateComponentName(string);
        if (this.specsByAWTComponent.get(component) != null) {
            throw new IllegalStateException("Component " + String.valueOf(component) + " is already in the layout");
        }
        if (!string.equals(component.getName())) {
            component.setName(string);
        }
        ComponentSpecifications componentSpecifications = this.getComponentSpecifications(string);
        componentSpecifications.setComponent(component);
        this.specsByAWTComponent.put(component, componentSpecifications);
        this.dependencies = null;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            this.addLayoutComponent((String)object, component);
            return;
        }
        String string = component.getName();
        if (string != null) {
            this.addLayoutComponent(string, component);
            return;
        }
        throw new IllegalArgumentException("Unrecognizable constraints");
    }

    public void addConstraint(String string, AttributeType attributeType, Constraint constraint) {
        this.validateComponentName(string);
        this.getComponentSpecifications(string).addConstraint(attributeType, constraint);
        this.dependencies = null;
    }

    private void resolveContainerSpecs(int n, int n2) {
        this.getComponentSpecifications("_container").setContainerSpecs(n, n2);
    }

    private void resolveComponents(boolean bl, int n, int n2) {
        boolean bl2 = false;
        if (this.dependencies == null) {
            this.dependencies = new DependencyManager();
            bl2 = true;
        }
        for (ComponentSpecifications object : this.componentSpecs.values()) {
            object.clearAttributeValues();
            if (!bl2 || object.getComponentName() == "_container") continue;
            object.reportDependencies(this.dependencies);
        }
        this.resolveContainerSpecs(n, n2);
        Iterator<ComponentSpecifications> iterator = this.dependencies.sort().listIterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            ComponentSpecifications componentSpecifications = this.getComponentSpecifications(attribute.getComponent());
            componentSpecifications.computeAttribute(attribute.getType(), this.attributeSource, bl, n, n2);
        }
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().width - insets.left - insets.right;
        int n2 = container.getSize().height - insets.top - insets.bottom;
        this.resolveComponents(false, n, n2);
        for (ComponentSpecifications componentSpecifications : this.componentSpecs.values()) {
            componentSpecifications.layoutComponent(insets.left, insets.top);
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        ComponentSpecifications componentSpecifications = this.specsByAWTComponent.get(component);
        if (componentSpecifications != null) {
            this.specsByAWTComponent.remove(component);
            this.componentSpecs.remove(componentSpecifications.getComponentName());
            this.dependencies = null;
        }
    }

    private Dimension calculateBoundingBox() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (ComponentSpecifications componentSpecifications : this.componentSpecs.values()) {
            n = Math.min(n, componentSpecifications.getAttributeValue(AttributeType.LEFT));
            n2 = Math.min(n2, componentSpecifications.getAttributeValue(AttributeType.TOP));
            n3 = Math.max(n3, componentSpecifications.getAttributeValue(AttributeType.RIGHT));
            n4 = Math.max(n4, componentSpecifications.getAttributeValue(AttributeType.BOTTOM));
        }
        return new Dimension(n3 - n, n4 - n2);
    }

    private Dimension addInsets(Dimension dimension, Container container) {
        Insets insets = container.getInsets();
        return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.resolveComponents(false, 0, 0);
        return this.addInsets(this.calculateBoundingBox(), container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.resolveComponents(true, 0, 0);
        return this.addInsets(this.calculateBoundingBox(), container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }
}

