/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AddressBar
extends JComboBox<Object>
implements IViewModel.ModelListener,
ItemListener,
PopupMenuListener {
    private IViewModel m_Model;
    private Comparator<IPanelView> m_PanelViewComparator = new PanelViewComparator();
    private static final long serialVersionUID = 1L;

    public AddressBar(IViewModel iViewModel) {
        this.m_Model = iViewModel;
        this.m_Model.addModelListener(this);
        this.addItemListener(this);
        this.addPopupMenuListener(this);
        this.setRenderer(new CellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void viewChanged() {
        this.removeItemListener(this);
        IPanelView iPanelView = this.m_Model.getCurrentView();
        this.refreshViews();
        this.setSelectedItem(iPanelView);
        this.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            IPanelView iPanelView = (IPanelView)this.getSelectedItem();
            this.m_Model.setCurrentView(iPanelView);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = 32;
        return dimension;
    }

    @Override
    public String getToolTipText() {
        IPanelView iPanelView = (IPanelView)this.getSelectedItem();
        return iPanelView == null ? null : iPanelView.getName();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        Accessible accessible = this.getUI().getAccessibleChild(this, 0);
        if (!(accessible instanceof JPopupMenu)) {
            return;
        }
        JComponent jComponent = (JComponent)((JPopupMenu)accessible).getComponent(0);
        Dimension dimension = new Dimension();
        dimension.width = Math.max(this.getSize().width, this.getPreferredSize().width);
        dimension.height = jComponent.getPreferredSize().height;
        jComponent.setPreferredSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    protected void refreshViews() {
        List<IPanelView> list = this.m_Model.getPanelViews();
        this.removeAllItems();
        IPanelView[] iPanelViewArray = new IPanelView[list.size()];
        list.toArray(iPanelViewArray);
        Arrays.sort(iPanelViewArray, this.m_PanelViewComparator);
        for (int i = 0; i < iPanelViewArray.length; ++i) {
            this.addItem(iPanelViewArray[i]);
        }
    }

    public static class PanelViewComparator
    implements Comparator<IPanelView> {
        @Override
        public int compare(IPanelView iPanelView, IPanelView iPanelView2) {
            return iPanelView.getName().compareTo(iPanelView2.getName());
        }
    }

    private static class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                IPanelView iPanelView = (IPanelView)object;
                jLabel.setText(iPanelView.getName());
                jLabel.setIcon(iPanelView.getIcon());
            }
            return jLabel;
        }
    }
}

