/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.Configuration;

public class ArchLauncher {
    public static final String ELIXIR_HOME = "elixir.home";
    public static final String ELIXIR_EXT = "elixir.ext";
    public static final String SECURITY_POLICY = "java.security.policy";
    public static final String AUTH_CONFIG = "java.security.auth.login.config";

    private static void loadAuthConfig(File file, String string) throws IOException {
        boolean bl = false;
        Object object = System.getProperty(AUTH_CONFIG);
        if (object == null) {
            File file2 = new File(file, "config");
            object = file2.getCanonicalPath() + string + "auth.conf";
            System.setProperty(AUTH_CONFIG, (String)object);
            bl = true;
        }
        if (bl) {
            Configuration.getConfiguration().refresh();
        }
    }

    protected static void displayExceptionAndExit(Exception exception, String string) {
        if (exception instanceof SQLException) {
            SQLException sQLException = (SQLException)exception;
            System.err.println("SQLException " + string);
            do {
                sQLException.printStackTrace();
            } while ((sQLException = sQLException.getNextException()) != null);
        } else {
            System.err.println("Unknown error " + string);
            exception.printStackTrace();
        }
        System.exit(-1);
    }

    protected static URL[] buildClassLoaderURLs(File file) throws MalformedURLException, IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        File file2 = null;
        Properties properties = System.getProperties();
        if (properties.containsKey(ELIXIR_EXT)) {
            file2 = new File((String)properties.get(ELIXIR_EXT));
        } else {
            file2 = new File(file, "ext");
            properties.put(ELIXIR_EXT, file2.getAbsolutePath());
        }
        arrayList.add(file2.getCanonicalFile().toURI().toURL());
        ArchLauncher.buildURLs(file2, arrayList);
        File file3 = new File(file, "lib");
        arrayList.add(file3.getCanonicalFile().toURI().toURL());
        ArchLauncher.buildURLs(file3, arrayList);
        URL[] uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        System.out.println("ClassPath");
        System.out.println("--------");
        for (int i = 0; i < uRLArray.length; ++i) {
            System.out.println(uRLArray[i]);
        }
        System.out.println("--------");
        return uRLArray;
    }

    public static void buildURLs(File file, List<URL> list) throws MalformedURLException, IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return file.getName().compareTo(file2.getName());
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    ArchLauncher.buildURLs(fileArray[i], list);
                    continue;
                }
                if (!fileArray[i].getName().endsWith(".jar")) continue;
                list.add(fileArray[i].getCanonicalFile().toURI().toURL());
            }
        }
    }

    public static File getHome() {
        String string = new File(".").getAbsolutePath();
        System.setProperty(ELIXIR_HOME, string);
        System.out.println("Using home: " + string);
        return new File(string);
    }

    private static String canonicalizeFilePath(String string) {
        File file = new File(ArchLauncher.removeTrailingSeparator(string));
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            System.out.println("Unable to canonicalize the file path: '" + string + "'.");
            iOException.printStackTrace();
            return file.getAbsolutePath();
        }
    }

    private static String removeTrailingSeparator(String string) {
        String string2 = System.getProperty("file.separator");
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            ArchLauncher.copy(fileInputStream, fileOutputStream);
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        ArchLauncher.channelCopy(readableByteChannel, writableByteChannel);
    }

    public static void channelCopy(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            byteBuffer.compact();
        }
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            writableByteChannel.write(byteBuffer);
        }
    }
}

