/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.IDirtyState;
import java.util.ArrayList;
import java.util.List;

public class CompositeDirtyState
implements IDirtyState,
IDirtyState.Listener {
    private List<IDirtyState> m_DirtyStates = new ArrayList<IDirtyState>();
    private List<IDirtyState.Listener> m_DirtyListeners;
    private boolean m_UpdateInProgress;

    public void add(IDirtyState iDirtyState) {
        if (iDirtyState != null) {
            this.m_DirtyStates.add(iDirtyState);
            iDirtyState.addDirtyListener(this);
        }
    }

    public void remove(IDirtyState iDirtyState) {
        if (iDirtyState != null) {
            this.m_DirtyStates.remove(iDirtyState);
            iDirtyState.removeDirtyListener(this);
        }
    }

    @Override
    public boolean isDirty() {
        for (IDirtyState iDirtyState : this.m_DirtyStates) {
            if (!iDirtyState.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDirty(boolean bl) {
        this.m_UpdateInProgress = true;
        for (IDirtyState iDirtyState : this.m_DirtyStates) {
            iDirtyState.setDirty(bl);
        }
        this.m_UpdateInProgress = false;
        this.fireDirtyStateChanged();
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener listener) {
        if (this.m_DirtyListeners == null) {
            this.m_DirtyListeners = new ArrayList<IDirtyState.Listener>();
        }
        this.m_DirtyListeners.add(listener);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener listener) {
        this.m_DirtyListeners.remove(listener);
    }

    @Override
    public void dirtyStateChanged(IDirtyState iDirtyState) {
        this.fireDirtyStateChanged();
    }

    protected void fireDirtyStateChanged() {
        if (!this.m_UpdateInProgress && this.m_DirtyListeners != null) {
            for (IDirtyState.Listener listener : this.m_DirtyListeners) {
                listener.dirtyStateChanged(this);
            }
        }
    }
}

