/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.ArchAction;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.ManagedTable;
import com.elixirtech.arch.log.LogModel;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.StrBuffer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class ConsolePanel
extends JPanel
implements ItemListener,
ActionListener {
    private static final String LOG_ID_PREFIX = "Log ID: ";
    ManagedTable m_Table;
    private JComboBox m_ComboBox;
    private JTextField m_CommandLine;
    private LogModel[] m_Models;
    private static final long serialVersionUID = 1L;

    public ConsolePanel() {
        int n;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        String[] stringArray = new String[LogModel.COLUMNS.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = Bundle.ARCH.getString("LogModel." + LogModel.COLUMNS[n]);
        }
        this.m_Models = LogModel.getLogModels();
        for (n = 0; n < this.m_Models.length; ++n) {
            this.m_Models[n].setColumns(stringArray);
        }
        this.m_ComboBox = new JComboBox<LogModel>(new DefaultComboBoxModel<LogModel>(this.m_Models));
        if (this.m_ComboBox.getItemCount() > 0) {
            this.m_ComboBox.setSelectedIndex(0);
        }
        this.m_ComboBox.addItemListener(this);
        jPanel.add((Component)this.m_ComboBox, "West");
        this.m_CommandLine = new JTextField();
        this.m_CommandLine.addActionListener(this);
        jPanel.add((Component)this.m_CommandLine, "Center");
        JToolBar jToolBar = SwingFactory.newToolBar();
        jToolBar.add(new SaveAction());
        jToolBar.add(new ClearAction());
        jPanel.add((Component)jToolBar, "East");
        this.add((Component)jPanel, "North");
        this.m_Table = new ManagedTable("ConsolePanel");
        this.m_Table.setAutoResizeMode(0);
        this.add((Component)new JScrollPane(this.m_Table), "Center");
        this.refreshList();
    }

    public static void verifyLogID(File file) throws IOException, NoSuchAlgorithmException {
        String string;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while (true) {
            if ((string = bufferedReader.readLine()) == null) {
                throw new RuntimeException("No Log ID found");
            }
            if (string.startsWith(LOG_ID_PREFIX)) break;
            outputStreamWriter.write(string);
        }
        outputStreamWriter.close();
        StrBuffer strBuffer = new StrBuffer();
        strBuffer.append(LOG_ID_PREFIX);
        byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
        for (int i = 0; i < byArray.length; ++i) {
            strBuffer.append(ConsolePanel.hex(byArray[i]));
        }
        if (!strBuffer.toString().equals(string)) {
            throw new RuntimeException("Bad Log ID");
        }
        System.out.println("Log ID Ok");
    }

    public void dispose() {
        if (this.m_Table.columnsLoaded()) {
            this.m_Table.saveColumns();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.refreshList();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.m_CommandLine.getText();
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        try {
            Object object = javaScriptEngine.evaluate("Console", string);
            javaScriptEngine.getLog().info(object);
        }
        catch (ScriptException scriptException) {
            ElixirJ.error(Bundle.ARCH.getString("ConsolePanel.CONSOLE_SCRIPT_ERROR"), scriptException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(File file) throws IOException {
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println(this.getSystemInfo());
            for (int i = 0; i < this.m_Models.length; ++i) {
                this.m_Models[i].serialize(printWriter);
            }
        }
    }

    private void refreshList() {
        int n;
        if (this.m_Table.columnsLoaded()) {
            this.m_Table.saveColumns();
        }
        if ((n = this.m_ComboBox.getSelectedIndex()) >= 0) {
            this.m_Table.setModel(this.m_Models[n]);
            this.m_Table.loadColumns();
        }
    }

    JFrame getFrame() {
        Container container = this;
        while (!(container instanceof JFrame)) {
            container = container.getParent();
        }
        return (JFrame)container;
    }

    private String getSystemInfo() {
        IApplication iApplication = (IApplication)Elixir.get(IApplication.class);
        StrBuffer strBuffer = new StrBuffer();
        String string = System.getProperty("line.separator");
        strBuffer.append("Elixir Log ver 1.0" + string);
        strBuffer.append("Time: " + String.valueOf(new Date()) + string);
        strBuffer.append("Application: " + iApplication.getTitle() + string);
        strBuffer.append("Build: " + iApplication.getBuild() + string);
        strBuffer.append("Operating System: " + System.getProperty("os.name") + " arch=" + System.getProperty("os.arch") + " version=" + System.getProperty("os.version") + string);
        strBuffer.append("Java Version: " + System.getProperty("java.version") + string);
        strBuffer.append("Java Vendor: " + System.getProperty("java.vendor") + string);
        strBuffer.append("User Home: " + System.getProperty("user.home") + string);
        strBuffer.append("User: " + System.getProperty("Elixir.User") + string);
        strBuffer.append("Expiry: " + System.getProperty("Elixir.Expiry") + string);
        strBuffer.append("Elixir.Home: " + ElixirJ.getHomeDir().getAbsolutePath() + string);
        strBuffer.append("Elixir.Config: " + ElixirJ.getConfigDir().getAbsolutePath() + string);
        strBuffer.append("Java ClassPath" + string);
        String string2 = System.getProperty("java.class.path");
        String[] stringArray = string2.split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            strBuffer.append(stringArray[i] + string);
        }
        strBuffer.append(string);
        strBuffer.append(this.digest(strBuffer.toString()) + string);
        return strBuffer.toString();
    }

    private String digest(String string) {
        StrBuffer strBuffer = new StrBuffer();
        try {
            Object object;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((object = bufferedReader.readLine()) != null) {
                outputStreamWriter.write((String)object);
            }
            outputStreamWriter.close();
            object = messageDigest.digest(byteArrayOutputStream.toByteArray());
            strBuffer.append(LOG_ID_PREFIX);
            for (int i = 0; i < ((Object)object).length; ++i) {
                strBuffer.append(ConsolePanel.hex((byte)object[i]));
            }
        }
        catch (Exception exception) {
            strBuffer.append("Log ID Error");
        }
        return strBuffer.toString();
    }

    private static String hex(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 128;
        }
        return Integer.toHexString(n2);
    }

    private class SaveAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            super("Console.Save");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FileSaveDialog fileSaveDialog = new FileSaveDialog();
                fileSaveDialog.setFilter("log", Bundle.ARCH.getString("ConsolePanel.FILE_TYPE"));
                if (fileSaveDialog.showSaveDialog(ConsolePanel.this) == 0) {
                    File file = fileSaveDialog.getSelectedFile();
                    if (file.getName().indexOf(46) < 0) {
                        file = new File(file.getAbsolutePath() + ".log");
                    }
                    ConsolePanel.this.serialize(file);
                }
            }
            catch (IOException iOException) {
                ElixirJ.error(Bundle.ARCH.getString("ConsolePanel.ERROR_SAVING_CONSOLE"), iOException);
            }
        }
    }

    private class ClearAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public ClearAction() {
            super("Console.Clear");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((LogModel)ConsolePanel.this.m_Table.getModel()).clear();
        }
    }
}

