/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.ConsolePanel;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.IConsoleManager;
import com.elixirtech.arch.ManagedFrame;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class DefaultConsoleManager
implements IConsoleManager {
    JFrame m_Frame;
    ConsolePanel m_Panel;

    @Override
    public void show() {
        if (this.m_Frame == null) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            IApplication iApplication = (IApplication)Elixir.get(IApplication.class);
            String string = Bundle.ARCH.getString("Console.Title");
            this.m_Frame = new ManagedFrame("Console", iApplication.getTitle() + " " + string);
            this.m_Frame.setIconImage(I18NUtil.getIcon(Bundle.ARCH, "Console").getImage());
            this.m_Panel = new ConsolePanel();
            this.m_Frame.getContentPane().add(this.m_Panel);
            this.m_Frame.setDefaultCloseOperation(0);
            this.m_Frame.addWindowListener(new WL());
            this.m_Frame.setSize(500, 400);
            this.m_Frame.setLocationRelativeTo(elixirFrame.getFrame());
            this.m_Frame.setVisible(true);
        } else {
            if (this.m_Frame.getState() == 1) {
                this.m_Frame.setState(0);
            }
            this.m_Frame.requestFocus();
        }
    }

    @Override
    public void hide() {
        if (this.m_Frame != null) {
            this.m_Panel.dispose();
            this.m_Frame.dispose();
            this.m_Frame = null;
        }
    }

    @Override
    public boolean isShowing() {
        return this.m_Frame != null;
    }

    private class WL
    extends WindowAdapter {
        private WL() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DefaultConsoleManager.this.m_Panel.dispose();
            windowEvent.getWindow().dispose();
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            DefaultConsoleManager.this.m_Frame = null;
        }
    }
}

