/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.IUser;
import com.elixirtech.arch.ManagedTable;
import com.elixirtech.arch.licence.DefaultUserUtil;
import com.elixirtech.arch.licence.LicenceException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;

public class DefaultUser
implements IUser {
    private IApplication m_App;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DefaultUser.class);

    public static void resetState(Class<?> clazz) {
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        if (preferences != null) {
            try {
                preferences.removeNode();
            }
            catch (BackingStoreException backingStoreException) {
                m_Log.error((Object)("Unable to reset state: " + String.valueOf(backingStoreException)));
            }
        }
    }

    public DefaultUser(IApplication iApplication) {
        this.m_App = iApplication;
    }

    @Override
    public void loadFrameData(String string, Window window) {
        Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
        Preferences preferences2 = null;
        preferences2 = window instanceof JFrame ? preferences.node("frame/" + string) : (window instanceof JDialog ? preferences.node("dialog/" + string) : preferences.node("window/" + string));
        int n = preferences2.getInt("state", 0);
        Rectangle rectangle = window.getBounds();
        int n2 = preferences2.getInt("left", rectangle.x);
        int n3 = preferences2.getInt("top", rectangle.y);
        int n4 = preferences2.getInt("width", rectangle.width);
        int n5 = preferences2.getInt("height", rectangle.height);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > dimension.width) {
            n4 = dimension.width;
        }
        if (n5 > dimension.height) {
            n5 = dimension.height;
        }
        if (n2 + n4 > dimension.width) {
            n2 -= n2 + n4 - dimension.width;
        }
        if (n3 + n5 > dimension.height) {
            n3 -= n3 + n5 - dimension.height;
        }
        window.setBounds(n2, n3, n4, n5);
        if (window instanceof JFrame) {
            ((JFrame)window).setExtendedState(n);
        }
    }

    @Override
    public void saveFrameData(String string, Window window) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
            Preferences preferences2 = null;
            if (window instanceof JFrame) {
                preferences2 = preferences.node("frame/" + string);
                preferences2.putInt("state", ((JFrame)window).getExtendedState());
                ((JFrame)window).setExtendedState(0);
            } else if (window instanceof JDialog) {
                preferences2 = preferences.node("dialog/" + string);
            } else {
                throw new IllegalArgumentException("Window type " + String.valueOf(window.getClass()) + " not supported");
            }
            Rectangle rectangle = window.getBounds();
            preferences2.putInt("left", rectangle.x);
            preferences2.putInt("top", rectangle.y);
            preferences2.putInt("width", rectangle.width);
            preferences2.putInt("height", rectangle.height);
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            m_Log.warn((Object)("Unable to save frame configuration: " + String.valueOf(backingStoreException)));
        }
    }

    public void clearFrameData(String string) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
            Preferences preferences2 = preferences.node(string);
            preferences2.clear();
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            m_Log.warn((Object)("Unable to clear frame configuration: " + String.valueOf(backingStoreException)));
        }
    }

    @Override
    public int getSplit(String string, int n) {
        Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
        Preferences preferences2 = preferences.node("splits");
        return preferences2.getInt(string, n);
    }

    @Override
    public void setSplit(String string, int n) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
            Preferences preferences2 = preferences.node("splits");
            preferences2.putInt(string, n);
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            m_Log.warn((Object)("Unable to save split configuration: " + String.valueOf(backingStoreException)));
        }
    }

    @Override
    public void loadTableData(String string, JTable jTable) {
        Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
        Preferences preferences2 = preferences.node("tables");
        String string2 = preferences2.get(string, null);
        ManagedTable.setTableString(jTable, string2);
    }

    @Override
    public void saveTableData(String string, JTable jTable) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
            Preferences preferences2 = preferences.node("tables");
            String string2 = ManagedTable.getTableString(jTable);
            preferences2.put(string, string2);
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            m_Log.warn((Object)("Unable to save table configuration: " + String.valueOf(backingStoreException)));
        }
    }

    @Override
    public void setInt(String string, int n) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
            Preferences preferences2 = preferences.node("preferences");
            preferences2.putInt(string, n);
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            m_Log.warn((Object)("Unable to save int " + string + ": " + String.valueOf(backingStoreException)));
        }
    }

    @Override
    public int getInt(String string, int n) {
        Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
        Preferences preferences2 = preferences.node("preferences");
        return preferences2.getInt(string, n);
    }

    @Override
    public void setString(String string, String string2) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
            Preferences preferences2 = preferences.node("preferences");
            preferences2.put(string, string2);
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            m_Log.warn((Object)("Unable to save " + string + ": " + String.valueOf(backingStoreException)));
        }
    }

    @Override
    public String getString(String string, String string2) {
        Preferences preferences = Preferences.userNodeForPackage(this.m_App.getClass());
        Preferences preferences2 = preferences.node("preferences");
        return preferences2.get(string, string2);
    }

    @Override
    public void saveLicense(String string) throws LicenceException {
        DefaultUserUtil.saveLicence(string);
    }
}

