/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IDesigner;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IUser;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.SplashPanel;
import com.elixirtech.arch.ViewBar;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class Designer
implements IDesigner {
    private IViewModel m_Model;
    private JSplitPane m_Splitter;
    private int m_LastSplitterLocation;
    private ViewBar m_ViewBar;
    private JPanel m_RightPanel;
    private JComponent m_CurrentView;
    private SplashPanel m_SplashPanel = new SplashPanel();

    public Designer(IViewModel iViewModel, ViewBar viewBar, IMasterPropertyList iMasterPropertyList) {
        this.m_Model = iViewModel;
        this.m_Model.addModelListener(this);
        this.m_ViewBar = viewBar;
        this.m_RightPanel = new JPanel(new BorderLayout());
        this.setRightPanelContents(this.m_SplashPanel);
        this.m_RightPanel.add((Component)this.m_ViewBar, "North");
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        this.m_Splitter = SwingFactory.newHorizontalSplit(repositoryExplorer.getComponent(), this.m_RightPanel);
        this.m_Splitter.setOneTouchExpandable(false);
        IUser iUser = (IUser)Elixir.get(IUser.class);
        this.m_Splitter.setDividerLocation(iUser.getSplit("Main", 180));
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        JFrame jFrame = elixirFrame.getFrame();
        jFrame.getContentPane().add(this.m_Splitter);
        jFrame.setVisible(true);
    }

    @Override
    public void collapseRepositoryExplorer() {
        this.m_LastSplitterLocation = this.m_Splitter.getDividerLocation();
        this.m_Splitter.setLeftComponent(null);
        this.m_ViewBar.setCollapsedState(true);
    }

    @Override
    public void expandRepositoryExplorer() {
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        this.m_Splitter.setLeftComponent(repositoryExplorer.getComponent());
        this.m_Splitter.setDividerLocation(this.m_LastSplitterLocation);
        this.m_LastSplitterLocation = 0;
        this.m_ViewBar.setCollapsedState(false);
    }

    @Override
    public void viewChanged() {
        IPanelView iPanelView = this.m_Model.getCurrentView();
        JComponent jComponent = null;
        if (iPanelView != null) {
            jComponent = iPanelView.getComponent();
        }
        this.setRightPanelContents(jComponent);
    }

    @Override
    public void saveAnyChanges() {
        IUser iUser = (IUser)Elixir.get(IUser.class);
        int n = this.m_LastSplitterLocation == 0 ? this.m_Splitter.getDividerLocation() : this.m_LastSplitterLocation;
        iUser.setSplit("Main", n);
    }

    protected void setRightPanelContents(JComponent jComponent) {
        if (this.m_CurrentView != jComponent) {
            if (this.m_CurrentView != null) {
                this.m_RightPanel.remove(this.m_CurrentView);
            }
            if (jComponent == null) {
                jComponent = this.m_SplashPanel;
            }
            this.m_RightPanel.add(jComponent);
            this.m_RightPanel.validate();
            this.m_CurrentView = jComponent;
        }
        this.m_RightPanel.repaint();
    }
}

