/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.CloseViewAction;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.IConsoleManager;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IPreSaver;
import com.elixirtech.arch.IProgressDisplayer;
import com.elixirtech.arch.IStateHolder;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.ManagedScalaFrame;
import com.elixirtech.arch.NextViewAction;
import com.elixirtech.arch.PrevViewAction;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.CursorUtil;
import com.elixirtech.ui.NarrowOptionPane;
import com.elixirtech.ui.property.IApplyRepainter;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardDialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Stack;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import scala.swing.Frame;

public class DesignerFrame
implements ElixirFrame,
IErrorHandler,
IApplyRepainter {
    ManagedScalaFrame m_ScalaFrame;
    JFrame m_Frame;
    private IProgressDisplayer m_ProgressDisplayer;
    private Stack<JDialog> m_WindowStack = new Stack();
    private String m_ArrowCursorSignal = "ArrowCursorSignal";
    private String m_Error = Bundle.ARCH.getString("Error");
    private String m_Warning = Bundle.ARCH.getString("Warning");
    private String m_Information = Bundle.ARCH.getString("Information");
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DesignerFrame.class);

    public DesignerFrame(IApplication iApplication) {
        this.m_ScalaFrame = new ManagedScalaFrame("MainFrame", iApplication.getTitle());
        this.m_Frame = this.m_ScalaFrame.getFrame();
        this.m_Frame.setDefaultCloseOperation(0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width > 1024 ? 1024 : 800;
        int n2 = dimension.width > 1024 ? 768 : 600;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        this.m_Frame.setBounds(n3, n4, n, n2);
        this.m_Frame.setIconImage(iApplication.getFrameIcon());
        this.m_Frame.addWindowListener(new WL());
        this.registerAccelerators();
    }

    @Override
    public String getFrameProperty(String string) {
        return null;
    }

    public void error(String string) {
        m_Log.error((Object)string);
        JFrame jFrame = this.getFrame();
        NarrowOptionPane.showMessageDialog(jFrame, string, this.m_Error, 0);
    }

    public void userError(String string) {
        JFrame jFrame = this.getFrame();
        NarrowOptionPane.showMessageDialog(jFrame, string, this.m_Error, 0);
    }

    public void warn(String string) {
        m_Log.warn((Object)string);
        JFrame jFrame = this.getFrame();
        NarrowOptionPane.showMessageDialog(jFrame, string, this.m_Warning, 2);
    }

    public void info(String string) {
        m_Log.info((Object)string);
        JFrame jFrame = this.getFrame();
        NarrowOptionPane.showMessageDialog(jFrame, string, this.m_Information, 1);
    }

    public void error(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
        JFrame jFrame = this.getFrame();
        NarrowOptionPane.showMessageDialog(jFrame, string, this.m_Error, 0);
    }

    @Override
    public void setProgressDisplayer(IProgressDisplayer iProgressDisplayer) {
        this.m_ProgressDisplayer = iProgressDisplayer;
    }

    public void setProgress(String string) {
        if (this.m_ProgressDisplayer != null) {
            this.m_ProgressDisplayer.setProgress(string);
        }
    }

    @Override
    public void setWaitCursor() {
        if (this.m_WindowStack.size() > 0) {
            JDialog jDialog = this.m_WindowStack.peek();
            CursorUtil.startWaitCursor(jDialog.getRootPane());
        } else {
            JFrame jFrame = this.getFrame();
            CursorUtil.startWaitCursor(jFrame.getRootPane());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArrowCursor() {
        Object object;
        if (this.m_WindowStack.size() > 0) {
            object = this.m_WindowStack.peek();
            CursorUtil.stopWaitCursor(((JDialog)object).getRootPane());
        } else {
            object = this.getFrame();
            CursorUtil.stopWaitCursor(((JFrame)object).getRootPane());
        }
        object = this.m_ArrowCursorSignal;
        synchronized (object) {
            this.m_ArrowCursorSignal.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForArrowCursor() {
        String string = this.m_ArrowCursorSignal;
        synchronized (string) {
            try {
                this.m_ArrowCursorSignal.wait();
            }
            catch (InterruptedException interruptedException) {
                m_Log.debug((Object)"waitForArrowCursor interrupted");
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void showWizard(IWizard iWizard) {
        WizardDialog wizardDialog = new WizardDialog(this.getFrame(), iWizard);
        this.showModal(wizardDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showModal(JDialog jDialog) {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        IPanelView iPanelView = iViewModel.getCurrentView();
        if (iPanelView != null) {
            iPanelView.setCurrent(false);
        }
        this.m_WindowStack.push(jDialog);
        try {
            IWizard iWizard;
            jDialog.setModal(true);
            jDialog.setVisible(true);
            if (jDialog instanceof WizardDialog && !(iWizard = ((WizardDialog)jDialog).getWizard()).isFinished()) {
                iPanelView = null;
            }
        }
        finally {
            this.m_WindowStack.pop();
            if (iPanelView != null) {
                iPanelView.setCurrent(true);
            }
            iViewModel.refreshView();
        }
    }

    @Override
    public boolean isModalShowing() {
        return !this.m_WindowStack.isEmpty();
    }

    @Override
    public void applyRepaint() {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        iViewModel.refreshView();
    }

    @Override
    public JFrame getFrame() {
        return this.m_Frame;
    }

    @Override
    public Frame getScalaFrame() {
        return this.m_ScalaFrame;
    }

    protected void registerAccelerators() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(115, 128);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(93, 128);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(91, 128);
        JComponent jComponent = (JComponent)this.m_Frame.getContentPane();
        InputMap inputMap = jComponent.getInputMap(2);
        ActionMap actionMap = jComponent.getActionMap();
        inputMap.put(keyStroke, "CloseViewAction");
        actionMap.put("Name", new CloseViewAction());
        inputMap.put(keyStroke2, "NextViewAction");
        actionMap.put("Name", new NextViewAction());
        inputMap.put(keyStroke3, "PrevViewAction");
        actionMap.put("Name", new PrevViewAction());
    }

    protected boolean saveAnyChanges() {
        for (IPreSaver object : ElixirJ.getAll(IPreSaver.class)) {
            if (object.preSaveAnyChanges()) continue;
            return false;
        }
        for (IStateHolder iStateHolder : ElixirJ.getAll(IStateHolder.class)) {
            iStateHolder.saveAnyChanges();
        }
        return true;
    }

    private class WL
    extends WindowAdapter {
        private WL() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (DesignerFrame.this.saveAnyChanges()) {
                IConsoleManager iConsoleManager = (IConsoleManager)Elixir.get(IConsoleManager.class);
                if (iConsoleManager != null) {
                    iConsoleManager.hide();
                }
                DesignerFrame.this.m_Frame.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

