/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.i18n.ResourceBundleLookup;
import com.elixirtech.ui.ImageManager;
import com.elixirtech.util.VariableSubstitution;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public abstract class ElixirAction
extends AbstractAction
implements Serializable {
    public static JMenuItem getMenuItem(JPopupMenu jPopupMenu, String string) {
        string = ElixirAction.stripSquareBrackets(string);
        Component[] componentArray = jPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            String string2;
            if (!(componentArray[i] instanceof JMenuItem) || !string.equals(string2 = (jMenuItem = (JMenuItem)componentArray[i]).getActionCommand())) continue;
            return jMenuItem;
        }
        return null;
    }

    public static JButton getButton(JToolBar jToolBar, String string) {
        string = ElixirAction.stripSquareBrackets(string);
        Component[] componentArray = jToolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JButton jButton;
            String string2;
            if (!(componentArray[i] instanceof JButton) || !string.equals(string2 = (jButton = (JButton)componentArray[i]).getActionCommand())) continue;
            return jButton;
        }
        return null;
    }

    public static JComboBox getCombo(JToolBar jToolBar, String string) {
        Component[] componentArray = jToolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JComboBox jComboBox;
            if (!(componentArray[i] instanceof JComboBox) || !string.equals((jComboBox = (JComboBox)componentArray[i]).getName())) continue;
            return jComboBox;
        }
        return null;
    }

    private static String stripSquareBrackets(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public ElixirAction(ResourceBundle resourceBundle, String string) {
        super(ElixirAction.getString(resourceBundle, string), ElixirAction.getIcon(resourceBundle, string));
        this.putValue("ActionCommandKey", string);
        this.setTip(resourceBundle, string);
        this.setMnemonic(resourceBundle, string);
    }

    protected static Icon getIcon(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = ElixirAction.getString(resourceBundle, string + ".Icon");
            string2 = VariableSubstitution.substitute(string2, new ResourceBundleLookup(resourceBundle));
            if (string2 != null) {
                return ImageManager.getIconResource(string2);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    protected void setTip(ResourceBundle resourceBundle, String string) {
        String string2 = ElixirAction.getString(resourceBundle, string + ".Tip");
        if (string2 != null) {
            this.putValue("ShortDescription", string2);
        }
    }

    protected void setMnemonic(ResourceBundle resourceBundle, String string) {
        String string2 = ElixirAction.getString(resourceBundle, string + ".Key");
        if (string2 != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
            this.putValue("AcceleratorKey", keyStroke);
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);
}

