/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.TerminateException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import scala.;
import scala.$less$colon$less$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.Arrays$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ElixirJ$
implements Serializable {
    private static final String ELIXIR_HOME;
    private static final String ELIXIR_CONFIG;
    private static final String ELIXIR_EXT;
    private static final String ELIXIR_DB;
    private static final String ELIXIR_SAFE_MODE;
    public static final ElixirJ$ MODULE$;

    private ElixirJ$() {
    }

    static {
        MODULE$ = new ElixirJ$();
        ELIXIR_HOME = "elixir.home";
        ELIXIR_CONFIG = "elixir.config";
        ELIXIR_EXT = "elixir.ext";
        ELIXIR_DB = "elixir.db";
        ELIXIR_SAFE_MODE = "elixir.safe.mode";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ElixirJ$.class);
    }

    public String ELIXIR_HOME() {
        return ELIXIR_HOME;
    }

    public String ELIXIR_CONFIG() {
        return ELIXIR_CONFIG;
    }

    public String ELIXIR_EXT() {
        return ELIXIR_EXT;
    }

    public String ELIXIR_DB() {
        return ELIXIR_DB;
    }

    public String ELIXIR_SAFE_MODE() {
        return ELIXIR_SAFE_MODE;
    }

    public <T> List<T> getAll(Class<T> cls) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Elixir$.MODULE$.getAll(cls)).asJava();
    }

    public void error(String msg) {
        IErrorHandler f = (IErrorHandler)Elixir$.MODULE$.get(IErrorHandler.class);
        f.error(msg);
    }

    public void userError(String msg) {
        IErrorHandler f = (IErrorHandler)Elixir$.MODULE$.get(IErrorHandler.class);
        f.userError(msg);
    }

    public void warn(String msg) {
        IErrorHandler f = (IErrorHandler)Elixir$.MODULE$.get(IErrorHandler.class);
        f.warn(msg);
    }

    public void error(String msg, Throwable t) {
        IErrorHandler f = (IErrorHandler)Elixir$.MODULE$.get(IErrorHandler.class);
        f.error(this.getErrorMsg(msg, t), t);
    }

    public String getErrorMsg(String userMsg, Throwable ex) {
        ResourceBundle rb = ResourceBundle.getBundle("i18n.base");
        String unknownError = rb.getString("Error.Unknown");
        String detailedMsg = ex.getLocalizedMessage();
        if (detailedMsg == null) {
            detailedMsg = unknownError;
        }
        if (userMsg.indexOf(detailedMsg) >= 0) {
            detailedMsg = "";
        }
        if (ex.getCause() == null) {
            if (detailedMsg == "") {
                return userMsg;
            }
            return this.getString(rb, "Error.Details", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{userMsg, detailedMsg}));
        }
        String cause = ex.getCause().getLocalizedMessage();
        if (detailedMsg == "") {
            return this.getString(rb, "Error.Details", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{userMsg, cause}));
        }
        return this.getString(rb, "Error.DetailsWithCause", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{userMsg, detailedMsg, cause}));
    }

    public String getString(ResourceBundle rb, String key, scala.collection.immutable.Seq<Object> args) {
        String pattern = rb.getString(key);
        if (pattern == null || pattern.trim().isEmpty()) {
            return pattern;
        }
        pattern = pattern.replace("'", "''");
        return MessageFormat.format(pattern, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
    }

    public boolean isSafeMode() {
        return System.getProperty(this.ELIXIR_SAFE_MODE()) != null;
    }

    public File getHomeDir() {
        String home = System.getProperty(this.ELIXIR_HOME());
        File ret = new File(home);
        ret.mkdirs();
        return ret;
    }

    public File getConfigDir() {
        String config = System.getProperty(this.ELIXIR_CONFIG());
        File ret = config != null ? new File(config) : new File(this.getHomeDir(), "config");
        ret.mkdirs();
        return ret;
    }

    public File getExtDir() {
        String ext = System.getProperty(this.ELIXIR_EXT());
        File ret = ext != null ? new File(ext) : new File(this.getHomeDir(), "ext");
        ret.mkdirs();
        return ret;
    }

    public File getHelpDir() {
        File home = this.getHomeDir();
        File ret = new File(home, "help");
        ret.mkdirs();
        return ret;
    }

    public File getDbDir() {
        String db = System.getProperty(this.ELIXIR_DB());
        File dbDir = db != null && db.trim().length() > 0 ? new File(db) : new File(this.getHomeDir(), "db");
        dbDir.mkdirs();
        return dbDir;
    }

    public InputStream getConfigStream(String name) throws IOException {
        File f = new File(this.getConfigDir(), name);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.getResourceAsStream("config/" + name);
    }

    public <K, V> Map<K, V> toImmutableMap(java.util.Map<K, V> in) {
        return CollectionConverters$.MODULE$.MapHasAsScala(in).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public void throwTerminate(int code, String msg) {
        throw new TerminateException(code, msg);
    }
}

