/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IPreSaver;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.SaveChanges;
import com.elixirtech.arch.repository.RepositoryAttributes;
import com.elixirtech.arch.worker.CreatePanelView;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.v2.repository.FileObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MultiViewModel
implements IPreSaver,
Serializable,
IViewModel {
    private static final long serialVersionUID = 1L;
    protected ElixirFrame m_Frame;
    protected List<IViewModel.ModelListener> m_Listeners = new ArrayList<IViewModel.ModelListener>();
    protected List<IPanelView> m_Views = new ArrayList<IPanelView>();
    protected IPanelView m_CurrentView;
    protected boolean m_ErrorClosing;

    public MultiViewModel(ElixirFrame elixirFrame) {
        this.m_Frame = elixirFrame;
    }

    @Override
    public IPanelView getCurrentView() {
        return this.m_CurrentView;
    }

    @Override
    public IPanelView openFile(FileObject fileObject) {
        IPanelView iPanelView = this.getView(fileObject);
        if (iPanelView == null) {
            CreatePanelView createPanelView = new CreatePanelView(fileObject);
            return createPanelView.showPanelView();
        }
        this.setCurrentView(iPanelView);
        return iPanelView;
    }

    @Override
    public IPanelView openFile(FileObject fileObject, Runnable runnable) {
        IPanelView iPanelView = this.getView(fileObject);
        if (iPanelView == null) {
            CreatePanelView createPanelView = new CreatePanelView(fileObject, runnable);
            return createPanelView.showPanelView();
        }
        this.setCurrentView(iPanelView);
        runnable.run();
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.setArrowCursor();
        return iPanelView;
    }

    @Override
    public IPanelView getView(FileObject fileObject) {
        for (IPanelView iPanelView : this.m_Views) {
            if (!fileObject.getPath().equals((Object)iPanelView.getFileObject().getPath())) continue;
            return iPanelView;
        }
        return null;
    }

    @Override
    public boolean isOpen(FileObject fileObject) {
        return this.getView(fileObject) != null;
    }

    @Override
    public void addView(IPanelView iPanelView) {
        FileObject fileObject = iPanelView.getFileObject();
        if (fileObject != null) {
            RepositoryAttributes.set(fileObject, "PanelView", iPanelView);
        }
        this.m_Views.add(iPanelView);
    }

    @Override
    public void setCurrentView(IPanelView iPanelView) {
        if (this.m_CurrentView != null) {
            this.m_CurrentView.setCurrent(false);
        }
        this.m_CurrentView = iPanelView;
        if (this.m_CurrentView != null) {
            this.m_CurrentView.setCurrent(true);
            int n = this.m_Views.size();
            IPanelView object = this.m_Views.get(n - 1);
            if (object != this.m_CurrentView) {
                this.m_Views.remove(this.m_CurrentView);
                this.m_Views.add(this.m_CurrentView);
            }
        }
        for (IViewModel.ModelListener modelListener : this.m_Listeners) {
            modelListener.viewChanged();
        }
    }

    @Override
    public void removeView(IPanelView iPanelView) {
        if (this.m_CurrentView == iPanelView) {
            this.m_Views.remove(iPanelView);
            FileObject fileObject = iPanelView.getFileObject();
            iPanelView.dispose();
            if (fileObject != null) {
                RepositoryAttributes.set(fileObject, "PanelView", null);
            }
            if (this.m_Views.isEmpty()) {
                this.setCurrentView(null);
            } else {
                int n = this.m_Views.size();
                this.setCurrentView(this.m_Views.get(n - 1));
            }
        } else {
            this.m_Views.remove(iPanelView);
            FileObject fileObject = iPanelView.getFileObject();
            iPanelView.dispose();
            if (fileObject != null) {
                RepositoryAttributes.set(fileObject, "PanelView", null);
            }
        }
    }

    @Override
    public void removeViews(List<IPanelView> list) {
        for (IPanelView iPanelView : list) {
            this.m_Views.remove(iPanelView);
            FileObject fileObject = iPanelView.getFileObject();
            iPanelView.dispose();
            if (fileObject == null) continue;
            RepositoryAttributes.set(fileObject, "PanelView", null);
        }
        if (list.contains(this.m_CurrentView)) {
            if (this.m_Views.isEmpty()) {
                this.setCurrentView(null);
            } else {
                int n = this.m_Views.size();
                this.setCurrentView(this.m_Views.get(n - 1));
            }
        }
    }

    @Override
    public void refreshView() {
        Iterator<IViewModel.ModelListener> iterator = this.m_Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().viewChanged();
        }
    }

    @Override
    public List<IPanelView> getPanelViews() {
        return Collections.unmodifiableList(this.m_Views);
    }

    @Override
    public void addModelListener(IViewModel.ModelListener modelListener) {
        this.m_Listeners.add(modelListener);
    }

    @Override
    public void removeModelListener(IViewModel.ModelListener modelListener) {
        this.m_Listeners.remove(modelListener);
    }

    @Override
    public void forceSaveAnyChanges() {
        for (IPanelView iPanelView : this.m_Views) {
            if (!iPanelView.canSave()) continue;
            try {
                iPanelView.save();
            }
            catch (Throwable throwable) {
                ElixirJ.error(Bundle.ARCH.getString("Error.SAVING_CHANGES"), throwable);
            }
        }
    }

    @Override
    public boolean preSaveAnyChanges() {
        try {
            boolean bl = false;
            for (IPanelView object : this.m_Views) {
                if (!object.canSave()) continue;
                bl = true;
                break;
            }
            if (bl) {
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                SaveChanges saveChanges = new SaveChanges(elixirFrame.getFrame());
                saveChanges.setLocationRelativeTo(elixirFrame.getFrame());
                elixirFrame.showModal(saveChanges);
                return !saveChanges.isCancelled();
            }
            return true;
        }
        catch (Exception exception) {
            ElixirJ.error(Bundle.ARCH.getString("MultiViewModel.ERROR_DURING_SAVE"), exception);
            if (this.m_ErrorClosing) {
                return true;
            }
            this.m_ErrorClosing = true;
            return false;
        }
    }
}

