/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.WizardMessageBar;
import com.elixirtech.util.CodeBlock;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SaveChanges
extends EscapableDialog {
    private static final long serialVersionUID = 1L;
    private List<Checker> m_Checkers = new ArrayList<Checker>();
    private boolean m_IsCompleted;

    public SaveChanges(JFrame jFrame) {
        this(jFrame, SaveChanges.getAllPanelViews());
    }

    public SaveChanges(JFrame jFrame, Collection<IPanelView> collection) {
        super((Frame)jFrame, true);
        this.setDefaultCloseOperation(0);
        this.setTitle(Bundle.ARCH.getString("SaveAnyChanges.Close"));
        Box box = Box.createVerticalBox();
        for (IPanelView object2 : collection) {
            if (!object2.canSave()) continue;
            Checker checker = new Checker(object2);
            box.add(checker.checkBox);
            this.m_Checkers.add(checker);
        }
        this.getContentPane().add((Component)new JScrollPane(box), "Center");
        WizardMessageBar wizardMessageBar = new WizardMessageBar();
        wizardMessageBar.setTitle(Bundle.ARCH.getString("SaveAnyChanges.Title"));
        if (this.m_Checkers.size() == 1) {
            wizardMessageBar.setMessage(Bundle.ARCH.getString("SaveAnyChanges.MessageOne"));
        } else {
            wizardMessageBar.setMessage(Bundle.ARCH.getString("SaveAnyChanges.MessageMany"));
        }
        this.getContentPane().add((Component)wizardMessageBar, "North");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(SwingFactory.newButton("SelectAll", new CodeBlock((Object)this, "selectAll")));
        jPanel.add(SwingFactory.newButton("DeselectAll", new CodeBlock((Object)this, "deselectAll")));
        jPanel.add(SwingFactory.newOkButton(new CodeBlock((Object)this, "saveSelected")));
        jPanel.add(SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel")));
        this.getContentPane().add((Component)jPanel, "South");
        Bundle.ARCH_MAP.injectComponents("SaveAnyChanges.", this.getContentPane());
        this.pack();
        this.setSize(500, 400);
    }

    public void selectAll() {
        for (Checker checker : this.m_Checkers) {
            checker.checkBox.setSelected(true);
        }
    }

    public void deselectAll() {
        for (Checker checker : this.m_Checkers) {
            checker.checkBox.setSelected(false);
        }
    }

    public void saveSelected() {
        for (Checker checker : this.m_Checkers) {
            if (!checker.checkBox.isSelected()) continue;
            try {
                checker.panelView.save();
            }
            catch (IOException iOException) {
                String string = I18NUtil.getString(Bundle.ARCH, "SaveChanges.CANT_SAVE_X", checker.panelView.getName());
                ElixirJ.error(string, iOException);
            }
        }
        this.m_IsCompleted = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public boolean isCancelled() {
        return !this.m_IsCompleted;
    }

    private static Collection<IPanelView> getAllPanelViews() {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        return iViewModel.getPanelViews();
    }

    private static class Checker {
        public IPanelView panelView;
        public JCheckBox checkBox;

        public Checker(IPanelView iPanelView) {
            this.panelView = iPanelView;
            this.checkBox = new JCheckBox();
            this.checkBox.setText(this.panelView.getName());
            this.checkBox.setSelected(true);
        }
    }
}

