/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IApplication;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Locale;
import javax.swing.JComponent;

public class SplashPanel
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Image m_Image;
    private Font m_Font = new Font("SansSerif", 0, 12);
    private String m_Build;
    private String m_Copyright;
    private String m_Runtime;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SplashPanel.class);

    public SplashPanel() {
        this.initApp();
    }

    private void initApp() {
        IApplication iApplication = (IApplication)Elixir.get(IApplication.class);
        this.m_Image = iApplication.getSplashImage();
        this.m_Build = iApplication.getBuild();
        this.m_Copyright = iApplication.getCopyright();
        this.m_Runtime = "This software is running on " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version");
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        float f = this.m_Image.getWidth(null);
        float f2 = this.m_Image.getHeight(null);
        int n = (int)(f2 * ((float)dimension.width / f));
        graphics.drawImage(this.m_Image, 0, 0, dimension.width, n, null);
        graphics.setColor(Color.black);
        graphics.setFont(this.m_Font);
        int n2 = 10;
        int n3 = dimension.height - 60;
        if (StringUtil.notEmpty(this.m_Copyright)) {
            n3 -= 20;
        }
        Locale locale = Locale.getDefault();
        graphics.drawString(this.m_Build + " (" + String.valueOf(locale) + ")", n2, n3);
        graphics.drawString(this.m_Copyright, n2, n3 += 20);
        graphics.drawString(this.m_Runtime, n2, n3 += 20);
    }
}

