/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.ElixirAction;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.util.StringStepper;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

public class UINavigatorUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(UINavigatorUtil.class);
    private static Map<Character, Entry> m_EntryMap = new HashMap<Character, Entry>();

    public static void processAction(JToolBar jToolBar, String string) {
        int n = (string = UINavigatorUtil.stripSquareBrackets(string)).indexOf("=");
        if (n > 0) {
            String string2 = string.substring(0, n);
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                JComboBox jComboBox = ElixirAction.getCombo(jToolBar, string2);
                jComboBox.setSelectedIndex(n2);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.error((Object)("Invalid combo box value: " + string));
            }
        } else {
            JButton jButton = ElixirAction.getButton(jToolBar, string);
            if (jButton != null) {
                jButton.doClick();
            }
        }
    }

    public static String stripSquareBrackets(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static Key[] stringToKeycodes(String string) {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        StringStepper stringStepper = new StringStepper(string);
        boolean bl = false;
        while (!stringStepper.atEnd()) {
            char c = stringStepper.getChar();
            if (Character.isLetter(c)) {
                if (Character.isUpperCase(c)) {
                    if (!bl) {
                        arrayList.add(Key.down(16));
                        bl = true;
                    }
                } else if (bl) {
                    arrayList.add(Key.up(16));
                    bl = false;
                }
                arrayList.add(Key.type(Character.toUpperCase(c)));
            } else if (Character.isDigit(c)) {
                arrayList.add(Key.type(c));
            } else {
                Entry entry = m_EntryMap.get(Character.valueOf(c));
                if (entry != null) {
                    if (entry.shift) {
                        if (!bl) {
                            arrayList.add(Key.down(16));
                            bl = true;
                        }
                    } else if (bl) {
                        arrayList.add(Key.up(16));
                        bl = false;
                    }
                    arrayList.add(Key.type(entry.code));
                }
            }
            stringStepper.advance();
        }
        if (bl) {
            arrayList.add(Key.up(16));
        }
        Key[] keyArray = new Key[arrayList.size()];
        arrayList.toArray(keyArray);
        return keyArray;
    }

    static {
        new Entry(' ', 32, false);
        new Entry(',', 44, false);
        new Entry('<', 44, true);
        new Entry('-', 45, false);
        new Entry('_', 45, true);
        new Entry('.', 46, false);
        new Entry('>', 46, true);
        new Entry('/', 47, false);
        new Entry('?', 47, true);
        new Entry(')', 48, true);
        new Entry('!', 49, true);
        new Entry('@', 50, true);
        new Entry('#', 51, true);
        new Entry('$', 52, true);
        new Entry('%', 53, true);
        new Entry('^', 54, true);
        new Entry('&', 55, true);
        new Entry('*', 56, true);
        new Entry('(', 57, true);
        new Entry(';', 59, false);
        new Entry(':', 59, true);
        new Entry('+', 61, true);
        new Entry('[', 91, false);
        new Entry('{', 91, true);
        new Entry('\\', 92, false);
        new Entry('|', 92, true);
        new Entry(']', 93, false);
        new Entry('}', 93, true);
        new Entry('`', 192, false);
        new Entry('~', 192, true);
        new Entry('\'', 222, false);
        new Entry('\"', 222, true);
    }

    public static class Key {
        public static final int DOWN = 1;
        public static final int UP = 2;
        public static final int TYPE = 3;
        private int m_Type;
        private int m_Keycode;

        public static Key down(int n) {
            return new Key(1, n);
        }

        public static Key up(int n) {
            return new Key(2, n);
        }

        public static Key type(int n) {
            return new Key(3, n);
        }

        public Key(int n, int n2) {
            this.m_Type = n;
            this.m_Keycode = n2;
        }

        public void apply(Robot robot) {
            if ((this.m_Type & 1) != 0) {
                robot.keyPress(this.m_Keycode);
            }
            if ((this.m_Type & 2) != 0) {
                robot.keyRelease(this.m_Keycode);
            }
        }
    }

    private static class Entry {
        public char ch;
        public int code;
        public boolean shift;

        public Entry(char c, int n, boolean bl) {
            this.ch = c;
            this.code = n;
            this.shift = bl;
            m_EntryMap.put(Character.valueOf(this.ch), this);
        }
    }
}

