/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.AddressBar;
import com.elixirtech.arch.ArchAction;
import com.elixirtech.arch.CloseViews;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirAction;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.GlobalPropertiesAction;
import com.elixirtech.arch.IConsoleManager;
import com.elixirtech.arch.IDesigner;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IThrobber;
import com.elixirtech.arch.IUINavigator;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.SaveChanges;
import com.elixirtech.arch.UINavigatorPath;
import com.elixirtech.arch.UINavigatorUtil;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryAttributes;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositorySaveWizard;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.v2.repository.FileObject;
import com.typesafe.config.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class ViewBar
extends JToolBar
implements IViewModel.ModelListener,
IUINavigator {
    private static final long serialVersionUID = 1L;
    public static final String HIDE_COLLAPSE = "ViewBar.HideCollapse";
    public IViewModel m_Model;
    private CollapseAction m_CollapseAction;
    private SaveViewAction m_SaveViewAction;
    private SaveViewAsAction m_SaveViewAsAction;
    private PropertiesAction m_PropertiesAction;
    private GlobalPropertiesAction m_GlobalPropertiesAction;
    private HelpAction m_HelpAction;
    private ConsoleAction m_ConsoleAction;
    private CloseViewAction m_CloseViewAction;

    public ViewBar(ElixirFrame elixirFrame, IViewModel iViewModel) {
        this.setLayout(new BorderLayout());
        this.setFloatable(false);
        this.setMargin(new Insets(2, 2, 3, 2));
        this.m_Model = iViewModel;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        this.m_CollapseAction = new CollapseAction();
        this.m_SaveViewAction = new SaveViewAction();
        this.m_SaveViewAsAction = new SaveViewAsAction();
        this.m_PropertiesAction = new PropertiesAction();
        this.m_HelpAction = new HelpAction();
        IConsoleManager iConsoleManager = (IConsoleManager)Elixir.get(IConsoleManager.class);
        if (iConsoleManager != null) {
            this.m_ConsoleAction = new ConsoleAction();
        }
        this.m_CloseViewAction = new CloseViewAction();
        String string = elixirFrame.getFrameProperty(HIDE_COLLAPSE);
        if (string == null) {
            jToolBar.add(this.m_CollapseAction);
            jToolBar.addSeparator();
        }
        jToolBar.add(this.m_SaveViewAction);
        jToolBar.add(this.m_SaveViewAsAction);
        jToolBar.add(this.m_PropertiesAction);
        jToolBar.addSeparator();
        this.m_GlobalPropertiesAction = new GlobalPropertiesAction();
        jToolBar.add(this.m_GlobalPropertiesAction);
        if (this.m_HelpAction != null) {
            jToolBar.add(this.m_HelpAction);
        }
        if (this.m_ConsoleAction != null) {
            jToolBar.add(this.m_ConsoleAction);
        }
        this.add((Component)jToolBar, "West");
        this.add((Component)new AddressBar(iViewModel), "Center");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setRollover(true);
        jToolBar2.setFloatable(false);
        jToolBar2.setBorderPainted(false);
        JButton jButton = jToolBar2.add(this.m_CloseViewAction);
        jButton.addMouseListener(new ClosePopupListener());
        jToolBar2.addSeparator();
        IThrobber iThrobber = (IThrobber)Elixir.get(IThrobber.class);
        if (iThrobber != null) {
            jToolBar2.add((JComponent)((Object)iThrobber));
        }
        this.add((Component)jToolBar2, "East");
        this.m_Model.addModelListener(this);
        JComponent jComponent = (JComponent)elixirFrame.getFrame().getContentPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(83, 2);
        jComponent.getActionMap().put(this.m_SaveViewAction, this.m_SaveViewAction);
        jComponent.getInputMap(2).put(keyStroke, this.m_SaveViewAction);
    }

    @Override
    public void showUINavigator(UINavigatorPath uINavigatorPath) {
        if (uINavigatorPath.hasNext()) {
            String string = uINavigatorPath.next();
            UINavigatorUtil.processAction(this, string);
        }
    }

    @Override
    public void viewChanged() {
        this.m_SaveViewAction.checkEnabled();
        this.m_SaveViewAsAction.checkEnabled();
        this.m_PropertiesAction.checkEnabled();
        this.m_CloseViewAction.checkEnabled();
    }

    public void setCollapsedState(boolean bl) {
        this.m_CollapseAction.setCollapsedState(bl);
    }

    protected IPanelView getView() {
        return this.m_Model.getCurrentView();
    }

    private static class CollapseAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;
        private boolean m_Collapsed;

        public CollapseAction() {
            super("Repository.Collapse");
            this.updateState();
        }

        public void setCollapsedState(boolean bl) {
            this.m_Collapsed = bl;
            this.updateState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_Collapsed) {
                IDesigner iDesigner = (IDesigner)Elixir.get(IDesigner.class);
                iDesigner.expandRepositoryExplorer();
            } else {
                IDesigner iDesigner = (IDesigner)Elixir.get(IDesigner.class);
                iDesigner.collapseRepositoryExplorer();
            }
        }

        protected void updateState() {
            if (this.m_Collapsed) {
                this.putValue("SmallIcon", CollapseAction.getIcon(Bundle.ARCH, "Repository.Expand"));
                this.setTip(Bundle.ARCH, "Repository.Expand");
            } else {
                this.putValue("SmallIcon", CollapseAction.getIcon(Bundle.ARCH, "Repository.Collapse"));
                this.setTip(Bundle.ARCH, "Repository.Collapse");
            }
        }
    }

    private class SaveViewAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public SaveViewAction() {
            super("File.Save");
            this.checkEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                IPanelView iPanelView = ViewBar.this.getView();
                if (iPanelView.canSave()) {
                    iPanelView.save();
                    IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                    if (iViewModel.getCurrentView() == iPanelView) {
                        iViewModel.refreshView();
                    }
                }
            }
            catch (IOException iOException) {
                ElixirJ.error(Bundle.ARCH.getString("ViewBar.SAVE_ERROR"), iOException);
            }
        }

        protected void checkEnabled() {
            IPanelView iPanelView = ViewBar.this.getView();
            this.setEnabled(iPanelView != null && iPanelView.canSave());
        }
    }

    private class SaveViewAsAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public SaveViewAsAction() {
            super("File.SaveAs");
            this.checkEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                IPanelView iPanelView = ViewBar.this.getView();
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                String string = (String)this.getValue("ShortDescription");
                FileObject fileObject = iPanelView.getFileObject();
                RepositorySaveWizard repositorySaveWizard = new RepositorySaveWizard(string, fileObject);
                elixirFrame.showWizard(repositorySaveWizard);
                if (repositorySaveWizard.isFinished()) {
                    RepositoryAttributes.set(fileObject, "PanelView", null);
                    FileObject fileObject2 = repositorySaveWizard.getSelection();
                    iPanelView.saveAs(fileObject2);
                    RepositoryAttributes.set(fileObject2, "PanelView", iPanelView);
                    IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                    iViewModel.refreshView();
                    RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
                    repositoryExplorer.select(fileObject2);
                }
            }
            catch (IOException iOException) {
                ElixirJ.error(Bundle.ARCH.getString("ViewBar.SAVE_ERROR"), iOException);
            }
        }

        protected void checkEnabled() {
            IPanelView iPanelView = ViewBar.this.getView();
            this.setEnabled(iPanelView != null && iPanelView.canSaveAs());
        }
    }

    private class PropertiesAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public PropertiesAction() {
            super("File.Properties");
            this.checkEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = this.getAction();
            if (action != null && action.isEnabled()) {
                action.actionPerformed(actionEvent);
            }
        }

        protected void checkEnabled() {
            boolean bl = false;
            IPanelView iPanelView = ViewBar.this.getView();
            if (iPanelView != null) {
                Action action = this.getAction();
                bl = action != null && action.isEnabled();
            }
            this.setEnabled(bl);
        }

        protected Action getAction() {
            RepositoryExplorer repositoryExplorer;
            FileType fileType;
            IPanelView iPanelView = ViewBar.this.getView();
            FileObject fileObject = iPanelView.getFileObject();
            if (fileObject != null && (fileType = (repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class)).getFileTypeJ(fileObject)) != null) {
                return fileType.getPropertiesAction(fileObject);
            }
            return null;
        }
    }

    private static class HelpAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public HelpAction() {
            super("Help.Open");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((Config)Elixir.get(Config.class)).getString("ambience.gui.help");
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(string));
            }
            catch (Exception exception) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error("Can't load help url");
            }
        }
    }

    private static class ConsoleAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public ConsoleAction() {
            super("Console.Open");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IConsoleManager iConsoleManager = (IConsoleManager)Elixir.get(IConsoleManager.class);
            iConsoleManager.show();
        }
    }

    private class CloseViewAction
    extends ElixirAction {
        private static final long serialVersionUID = 1L;

        protected CloseViewAction(ResourceBundle resourceBundle, String string) {
            super(resourceBundle, string);
            this.checkEnabled();
        }

        public CloseViewAction() {
            this(Bundle.ARCH, "File.Close");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IPanelView iPanelView = ViewBar.this.m_Model.getCurrentView();
            if (iPanelView.canSave()) {
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                ArrayList<IPanelView> arrayList = new ArrayList<IPanelView>();
                arrayList.add(iPanelView);
                SaveChanges saveChanges = new SaveChanges(elixirFrame.getFrame(), arrayList);
                saveChanges.setLocationRelativeTo(elixirFrame.getFrame());
                elixirFrame.showModal(saveChanges);
                if (saveChanges.isCancelled()) {
                    return;
                }
            }
            ViewBar.this.m_Model.removeView(iPanelView);
        }

        public void checkEnabled() {
            this.setEnabled(ViewBar.this.getView() != null);
        }
    }

    private class ClosePopupListener
    extends MouseAdapter {
        private ClosePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        protected void doPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new CloseThisViewAction());
            jPopupMenu.add(new CloseOtherViewsAction());
            jPopupMenu.add(new CloseAllViewsAction());
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public class CloseAllViewsAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public CloseAllViewsAction() {
            super("File.CloseAll");
            this.checkEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CloseViews.apply();
        }

        public void close() {
            Object object;
            ArrayList<IPanelView> arrayList = new ArrayList<IPanelView>();
            arrayList.addAll(ViewBar.this.m_Model.getPanelViews());
            Iterator iterator = arrayList.iterator();
            ArrayList<IPanelView> arrayList2 = new ArrayList<IPanelView>();
            while (iterator.hasNext()) {
                object = (IPanelView)iterator.next();
                if (!object.canSave()) continue;
                arrayList2.add((IPanelView)object);
            }
            if (arrayList2.size() > 0) {
                object = (ElixirFrame)Elixir.get(ElixirFrame.class);
                SaveChanges saveChanges = new SaveChanges(object.getFrame(), arrayList2);
                saveChanges.setLocationRelativeTo(object.getFrame());
                object.showModal(saveChanges);
                if (saveChanges.isCancelled()) {
                    return;
                }
            }
            ViewBar.this.m_Model.removeViews(arrayList);
        }

        public void checkEnabled() {
            this.setEnabled(ViewBar.this.m_Model.getPanelViews().size() > 1);
        }
    }

    private class CloseOtherViewsAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public CloseOtherViewsAction() {
            super("File.CloseOthers");
            this.checkEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            ArrayList<IPanelView> arrayList = new ArrayList<IPanelView>();
            arrayList.addAll(ViewBar.this.m_Model.getPanelViews());
            IPanelView iPanelView = ViewBar.this.m_Model.getCurrentView();
            arrayList.remove(iPanelView);
            Iterator iterator = arrayList.iterator();
            ArrayList<IPanelView> arrayList2 = new ArrayList<IPanelView>();
            while (iterator.hasNext()) {
                object = (IPanelView)iterator.next();
                if (!object.canSave()) continue;
                arrayList2.add((IPanelView)object);
            }
            if (arrayList2.size() > 0) {
                object = (ElixirFrame)Elixir.get(ElixirFrame.class);
                SaveChanges saveChanges = new SaveChanges(object.getFrame(), arrayList2);
                saveChanges.setLocationRelativeTo(object.getFrame());
                object.showModal(saveChanges);
                if (saveChanges.isCancelled()) {
                    return;
                }
            }
            ViewBar.this.m_Model.removeViews(arrayList);
            ViewBar.this.m_Model.setCurrentView(iPanelView);
        }

        public void checkEnabled() {
            this.setEnabled(ViewBar.this.m_Model.getPanelViews().size() > 1);
        }
    }

    private class CloseThisViewAction
    extends CloseViewAction {
        public CloseThisViewAction() {
            super(Bundle.ARCH, "File.CloseThis");
        }
    }
}

