/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.categorytype;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.categorytype.Category;
import com.elixirtech.arch.categorytype.ICategoryTypeRegistry;
import com.elixirtech.arch.categorytype.Type;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class AbstractCategoryTypeRegistry
implements ICategoryTypeRegistry {
    public static ResourceBundle RESOURCE_BUNDLE;
    protected HashMap<Category, List<Type>> m_MapCategoryType = new HashMap();
    protected Document m_ConfigDocument;
    protected static ElxLoggerJ m_Log;

    public AbstractCategoryTypeRegistry(ElxLoggerJ elxLoggerJ, String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream("/" + string);
        }
        try {
            RESOURCE_BUNDLE = new PropertyResourceBundle(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        m_Log = elxLoggerJ;
    }

    public AbstractCategoryTypeRegistry(ElxLoggerJ elxLoggerJ, ResourceBundle resourceBundle) {
        RESOURCE_BUNDLE = resourceBundle;
        m_Log = elxLoggerJ;
    }

    protected void load() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            this.m_ConfigDocument = sAXBuilder.build(this.getConfigStream());
            this.register(this.m_ConfigDocument.getRootElement());
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't read config: " + String.valueOf(exception)), (Throwable)exception);
        }
    }

    @Override
    public void registerType(Category category, Type type) {
        List<Object> list = null;
        if (this.m_MapCategoryType.containsKey(category)) {
            list = this.m_MapCategoryType.get(category);
            list.add(type);
        } else {
            list = new ArrayList<Type>();
            list.add(type);
            this.m_MapCategoryType.put(category, list);
        }
    }

    @Override
    public List<Category> getCategories() {
        ArrayList<Category> arrayList = new ArrayList<Category>();
        arrayList.addAll(this.m_MapCategoryType.keySet());
        return arrayList;
    }

    @Override
    public Category getCategory(String string) {
        Set<Category> set = this.m_MapCategoryType.keySet();
        for (Category category : set) {
            if (!string.equals(category.getName())) continue;
            return category;
        }
        return null;
    }

    @Override
    public List<Type> getTypes(Category category) {
        assert (this.m_MapCategoryType.containsKey(category));
        return Collections.unmodifiableList(this.m_MapCategoryType.get(category));
    }

    protected ResourceBundle getResource() {
        return RESOURCE_BUNDLE;
    }

    protected void register(Element element) {
        for (Element element2 : element.getChildren("category")) {
            String string = element2.getAttributeValue("name");
            String string2 = element2.getAttributeValue("display");
            if (StringUtil.isEmpty(string2)) {
                string2 = string;
            }
            Category category = new Category(string, string2, this.getResource());
            for (Element element3 : element2.getChildren("type")) {
                String string3 = element3.getAttributeValue("name");
                Type type = new Type(string3, this.getResource());
                this.registerType(category, type);
            }
        }
    }

    @Override
    public Type getType(Category category, String string) {
        for (Type type : this.getTypes(category)) {
            if (!type.getName().equals(string)) continue;
            return type;
        }
        return null;
    }

    protected abstract InputStream getConfigStream();
}

