/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.categorytype;

import com.elixirtech.arch.categorytype.Category;
import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.arch.categorytype.ICategoryTypeRegistry;
import com.elixirtech.arch.categorytype.Type;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoryTypeSelectionPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    protected JList m_Categories = SwingFactory.newList();
    protected JList m_Types = SwingFactory.newList();
    protected ICategoryTypeRegistry m_CategoryRegistry;
    protected ICategoryType m_CategoryType;

    public CategoryTypeSelectionPanel(ICategoryType iCategoryType, ICategoryTypeRegistry iCategoryTypeRegistry) {
        this(iCategoryType, iCategoryTypeRegistry, "12345678901345");
    }

    public CategoryTypeSelectionPanel(ICategoryType iCategoryType, ICategoryTypeRegistry iCategoryTypeRegistry, String string) {
        this.m_CategoryRegistry = iCategoryTypeRegistry;
        this.setCategoryType(iCategoryType);
        this.build(string);
    }

    public void setCategoryType(ICategoryType iCategoryType) {
        this.m_CategoryType = iCategoryType;
    }

    protected void build(String string) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add("West", new JScrollPane(this.m_Categories));
        this.add("Center", new JScrollPane(this.m_Types));
        this.m_Categories.setPrototypeCellValue(string);
        this.m_Categories.setCellRenderer(new LCellRenderer());
        this.m_Types.setCellRenderer(new LCellRenderer());
        this.buildCategories();
        this.m_Categories.addListSelectionListener(this);
        this.m_Types.addListSelectionListener(this);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_Categories.addListSelectionListener(listSelectionListener);
        this.m_Types.addListSelectionListener(listSelectionListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.m_Categories) {
            this.categorySelected((Category)this.m_Categories.getSelectedValue());
        } else if (listSelectionEvent.getSource() == this.m_Types) {
            this.typeSelected((Type)this.m_Types.getSelectedValue());
        }
    }

    private void buildCategories() {
        List<Category> list = this.m_CategoryRegistry.getCategories();
        Collections.sort(list, new Category.Comparator());
        DefaultListModel<Category> defaultListModel = new DefaultListModel<Category>();
        for (Category category : list) {
            defaultListModel.addElement(category);
        }
        this.m_Categories.setModel(defaultListModel);
    }

    public void updateFields() {
        Category category = this.m_CategoryRegistry.getCategory(this.m_CategoryType.getCategory());
        if (category != null) {
            this.m_Categories.removeListSelectionListener(this);
            this.m_Types.removeListSelectionListener(this);
            this.refreshTypeList(category);
            this.m_Categories.setSelectedValue(category, true);
            Type type = this.m_CategoryRegistry.getType(category, this.m_CategoryType.getType());
            if (type != null) {
                this.m_Types.setSelectedValue(type, true);
            }
            this.m_Categories.addListSelectionListener(this);
            this.m_Types.addListSelectionListener(this);
        }
    }

    public boolean isCategorySelected() {
        return !this.m_Categories.isSelectionEmpty();
    }

    public boolean isTypeSelected() {
        return !this.m_Types.isSelectionEmpty();
    }

    public void typeSelected(Type type) {
        if (this.m_CategoryType != null && type != null) {
            this.m_CategoryType.setType(type.getName());
        }
    }

    public void categorySelected(Category category) {
        this.refreshTypeList(category);
        this.m_CategoryType.setCategory(category.getName());
        this.m_Types.setSelectedIndex(0);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_Categories.setEnabled(bl);
        this.m_Types.setEnabled(bl);
    }

    private void refreshTypeList(Category category) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.addAll(this.m_CategoryRegistry.getTypes(category));
        this.m_Types.removeAll();
        Collections.sort(arrayList, new Type.Comparator());
        DefaultListModel<Type> defaultListModel = new DefaultListModel<Type>();
        for (Type type : arrayList) {
            defaultListModel.addElement(type);
        }
        this.m_Types.setModel(defaultListModel);
        this.m_Types.addListSelectionListener(this);
    }
}

